/*
 * Decompiled with CFR 0.152.
 */
package com.micros_retail.ant;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MacroDef;
import org.apache.tools.ant.taskdefs.MacroInstance;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class PropertyPathIterator
extends Task {
    private static final String INCLUDE_SUFFIX = ".includes";
    private static final String EXCLUDE_SUFFIX = ".excludes";
    private static final Pattern PATH_SEPARATOR = Pattern.compile(Pattern.quote(File.pathSeparator));
    private String _filterPrefix = "";
    private boolean _propertyFilter;
    private MacroDef _macroDef;
    private File _propertyFile;
    private String _propertyName;
    private String _includes;
    private String _excludes;
    private String _pathName;

    public MacroDef.NestedSequential createSequential() {
        return this.getMacroDef().createSequential();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        this.validate();
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this._propertyFile));){
            Properties properties = new Properties();
            properties.load(bufferedInputStream);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string = entry.getKey().toString();
                String string2 = entry.getValue().toString();
                MacroInstance macroInstance = this.getMacroInstance(this.getMacroDef(), string);
                Path path = new Path(this.getProject());
                for (String string3 : PATH_SEPARATOR.split(string2)) {
                    File file = new File(string3);
                    if (file.exists()) {
                        FileSet fileSet = this.buildFileSet(file, string);
                        path.addFileset(fileSet);
                        continue;
                    }
                    this.log(file + " does not appear to exist and will be skipped.");
                }
                if (path.size() == 0) {
                    this.log("No source paths were found for identifier " + string + ".  No execution will take place for that identifier.");
                    continue;
                }
                this.getProject().addReference(this._pathName, path);
                try {
                    macroInstance.execute();
                }
                finally {
                    this.getProject().getReferences().remove(this._pathName);
                }
            }
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    public void setExcludes(String string) {
        this._excludes = string;
    }

    public void setFilterPrefix(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.trim());
        if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '.') {
            stringBuilder.append('.');
        }
        this._filterPrefix = stringBuilder.toString();
    }

    public void setIncludes(String string) {
        this._includes = string;
    }

    public void setPathName(String string) {
        this._pathName = string;
    }

    public void setPropertyFile(File file) {
        this._propertyFile = file;
    }

    public void setPropertyFilters(boolean bl) {
        this._propertyFilter = bl;
    }

    public void setPropertyName(String string) {
        MacroDef.Attribute attribute = new MacroDef.Attribute();
        attribute.setName(string);
        this.getMacroDef().addConfiguredAttribute(attribute);
        this._propertyName = string;
    }

    private FileSet buildFileSet(File file, String string) {
        String[] stringArray;
        String[] stringArray2;
        CharSequence charSequence;
        FileSet fileSet = new FileSet();
        fileSet.setProject(this.getProject());
        fileSet.setDir(file);
        if (this._includes != null) {
            fileSet.setIncludes(this._includes);
        }
        if (this._excludes != null) {
            fileSet.setExcludes(this._excludes);
        }
        if (this._propertyFilter) {
            charSequence = this.getProject().getProperty(this._filterPrefix + string + INCLUDE_SUFFIX);
            if (charSequence != null) {
                fileSet.setIncludes((String)charSequence);
            }
            if ((stringArray2 = this.getProject().getProperty(this._filterPrefix + string + EXCLUDE_SUFFIX)) != null) {
                fileSet.setExcludes((String)stringArray2);
            }
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("[").append(string).append("] Dir: [").append(file.getAbsolutePath()).append("]");
        stringArray2 = fileSet.mergeIncludes(this.getProject());
        if (stringArray2 != null && stringArray2.length > 0) {
            ((StringBuilder)charSequence).append(" Includes: ").append(Arrays.asList(stringArray2));
        }
        if ((stringArray = fileSet.mergeExcludes(this.getProject())) != null && stringArray.length > 0) {
            ((StringBuilder)charSequence).append(" Excludes: ").append(Arrays.asList(stringArray));
        }
        this.log(((StringBuilder)charSequence).toString());
        return fileSet;
    }

    private MacroDef getMacroDef() {
        if (this._macroDef == null) {
            this._macroDef = new MacroDef();
            this._macroDef.setProject(this.getProject());
        }
        return this._macroDef;
    }

    private MacroInstance getMacroInstance(MacroDef macroDef, String string) {
        MacroInstance macroInstance = new MacroInstance();
        macroInstance.setProject(this.getProject());
        macroInstance.setOwningTarget(this.getOwningTarget());
        macroInstance.setMacroDef(macroDef);
        macroInstance.setDynamicAttribute(this._propertyName, string);
        return macroInstance;
    }

    private void validate() {
        if (this._macroDef == null) {
            throw new BuildException("You must add at least one task.");
        }
        if (this._propertyName == null) {
            throw new BuildException("You must provide a propertyname attribute.");
        }
        if (this._pathName == null) {
            throw new BuildException("You must provide a pathname attribute.");
        }
        if (this._propertyFile == null) {
            throw new BuildException("You must provide a propertyfile attribute.");
        }
    }
}

