/*
 * Decompiled with CFR 0.152.
 */
package com.micros_retail.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Sequential;
import org.apache.tools.ant.util.StringUtils;

public class TryCatch
extends Task {
    private Sequential _try;
    private Sequential _catch;
    private Sequential _finally;
    private String _property;
    private String _stackTraceProperty;
    private String _reference;

    public void addCatch(Sequential sequential) {
        if (this._catch != null) {
            throw new BuildException("Only one catch block can be provided.");
        }
        this._catch = sequential;
    }

    public void addFinally(Sequential sequential) {
        if (this._finally != null) {
            throw new BuildException("Only one finally block can be provided.");
        }
        this._finally = sequential;
    }

    public void addTry(Sequential sequential) {
        if (this._try != null) {
            throw new BuildException("Only one try block can be provided.");
        }
        this._try = sequential;
    }

    @Override
    public void execute() throws BuildException {
        block11: {
            if (this._try == null) {
                throw new BuildException("A try block must be provided");
            }
            try {
                this._try.execute();
            }
            catch (Throwable throwable) {
                if (this._property != null) {
                    this.getProject().setProperty(this._property, throwable.getMessage());
                }
                if (this._stackTraceProperty != null) {
                    this.getProject().setProperty(this._stackTraceProperty, StringUtils.getStackTrace(throwable));
                }
                if (this._reference != null) {
                    this.getProject().addReference(this._reference, throwable);
                }
                if (this._catch != null) {
                    this._catch.execute();
                    break block11;
                }
                throw throwable;
            }
            finally {
                if (this._finally != null) {
                    this._finally.execute();
                }
            }
        }
    }

    public void setProperty(String string) {
        this._property = string;
    }

    public void setReference(String string) {
        this._reference = string;
    }

    public void setStackTraceProperty(String string) {
        this._stackTraceProperty = string;
    }
}

