/*
 * Decompiled with CFR 0.152.
 */
package com.micros_retail.ant;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;

public class ValidateNoSvnPropTagsIncluded
extends Task {
    public static final Pattern SEARCH_PATTERN = Pattern.compile(".*\\$(URL|Revision|Id).*");
    private final List<Charset> _readerCharsets = new ArrayList<Charset>();
    private final Set<String> _ignoreSuffixes = new HashSet<String>();
    private final List<ResourceCollection> _resourceCollections = new ArrayList<ResourceCollection>();
    private final Map<String, String> _violations = Collections.synchronizedMap(new HashMap());
    private long _timeout = 120000L;
    private int _preloadLimit = 64;
    private boolean _useDefaultIgnores = true;

    public ValidateNoSvnPropTagsIncluded() {
        this._readerCharsets.add(StandardCharsets.UTF_8);
        this._readerCharsets.add(StandardCharsets.ISO_8859_1);
    }

    public void add(ResourceCollection resourceCollection) {
        this._resourceCollections.add(resourceCollection);
    }

    @Override
    public void execute() {
        if (this._useDefaultIgnores) {
            this._ignoreSuffixes.add(".cab");
            this._ignoreSuffixes.add(".class");
            this._ignoreSuffixes.add(".cache.js");
            this._ignoreSuffixes.add(".cache.html");
            this._ignoreSuffixes.add(".png");
            this._ignoreSuffixes.add(".jpg");
            this._ignoreSuffixes.add(".class");
            this._ignoreSuffixes.add(".class");
            this._ignoreSuffixes.add(".symbolMap");
            this._ignoreSuffixes.add(".tar.gz");
            this._ignoreSuffixes.add(".tgz");
            this._ignoreSuffixes.add(".ttf");
            this._ignoreSuffixes.add(".woff");
            this._ignoreSuffixes.add(".zip");
        }
        String[] stringArray = this._ignoreSuffixes.toArray(new String[this._ignoreSuffixes.size()]);
        this.log("Scanning files for $Id and $URL lines...");
        ExecutorService executorService = Executors.newWorkStealingPool();
        long l = System.currentTimeMillis();
        Semaphore semaphore = new Semaphore(this._preloadLimit);
        for (ResourceCollection object : this._resourceCollections) {
            for (Resource resource : object) {
                if (resource.isDirectory() || !this.isEligible(stringArray, resource.getName())) continue;
                this.scanResource(executorService, semaphore, resource);
            }
        }
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(this._timeout, TimeUnit.MILLISECONDS)) {
                throw new BuildException("Timed out waiting for file validation (waited " + this._timeout + "ms.)");
            }
        }
        catch (InterruptedException interruptedException) {
            executorService.shutdownNow();
            throw new BuildException("An exception occurred while waiting for file searches to complete.", interruptedException);
        }
        if (this._violations.size() > 0) {
            this.log("Issues were identified when scanning files:");
            for (Map.Entry entry : this._violations.entrySet()) {
                this.log((String)entry.getKey() + ":");
                this.log("          " + (String)entry.getValue());
            }
            throw new BuildException("File validation failed.");
        }
        this.log("Validation completed successfully. [Time: " + (System.currentTimeMillis() - l) + "ms]");
    }

    public void setAdditionalCharsets(String string) {
        for (String string2 : string.split(",")) {
            this._readerCharsets.add(Charset.forName(string2));
        }
    }

    public void setIgnoreSuffixes(String string) {
        String string2 = string.trim();
        if (string2.length() > 0) {
            this._ignoreSuffixes.addAll(Arrays.asList(string2.split(",")));
        }
    }

    public void setPreloadLimit(int n) {
        this._preloadLimit = n;
    }

    public void setTimeout(long l) {
        this._timeout = l;
    }

    public void setUseDefaultIgnores(boolean bl) {
        this._useDefaultIgnores = bl;
    }

    private boolean isEligible(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.endsWith(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    private byte[] readContent(Semaphore semaphore, Resource resource) throws IOException {
        long l = resource.getSize();
        if (l == -1L) {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                byte[] byArray;
                block22: {
                    InputStream inputStream = resource.getInputStream();
                    try {
                        byte[] byArray2 = new byte[8192];
                        int n = inputStream.read(byArray2);
                        while (n != -1) {
                            byteArrayOutputStream.write(byArray2, 0, n);
                            n = inputStream.read(byArray2);
                        }
                        byArray = byteArrayOutputStream.toByteArray();
                        if (inputStream == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    inputStream.close();
                }
                return byArray;
            }
        }
        if (l > Integer.MAX_VALUE) {
            this.log("Size of " + resource.getName() + " " + l + " bytes is larger than 2147483647 bytes and cannot be read.");
            return null;
        }
        byte[] byArray = new byte[(int)l];
        try (InputStream inputStream = resource.getInputStream();){
            int n = inputStream.read(byArray);
            if (n == byArray.length) {
                byte[] byArray3 = byArray;
                return byArray3;
            }
            throw new BuildException("Received a different number of bytes than expected (Expected " + byArray.length + ", Got " + n + ")");
        }
    }

    private void scanResource(ExecutorService executorService, Semaphore semaphore, Resource resource) {
        try {
            byte[] byArray = this.readContent(semaphore, resource);
            if (byArray != null) {
                executorService.submit(new SearchFileWorker(resource.getName(), byArray, this._violations, this._readerCharsets, semaphore));
            }
        }
        catch (Exception exception) {
            throw new BuildException("An exception occurred when reading resource " + resource.getName(), exception);
        }
    }

    private static class SearchFileWorker
    implements Runnable {
        private final String _searchFileName;
        private final byte[] _searchFileBytes;
        private final Map<String, String> _violations;
        private final List<Charset> _readerCharsets;
        private final Semaphore _fileLimit;

        SearchFileWorker(String string, byte[] byArray, Map<String, String> map, List<Charset> list, Semaphore semaphore) throws InterruptedException {
            this._searchFileName = string;
            this._searchFileBytes = byArray;
            this._violations = map;
            this._readerCharsets = list;
            this._fileLimit = semaphore;
            this._fileLimit.acquire();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private BufferedReader getReader(Charset charset) throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this._searchFileBytes), charset));
        }
    }
}

