/*
 * Decompiled with CFR 0.152.
 */
package oracle.retail.xstore.installer.eval;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import oracle.retail.xstore.installer.resource.IResource;
import oracle.retail.xstore.installer.resource.IResourceContainer;
import oracle.retail.xstore.installer.resource.ResourceContainerFactory;

public class Evaluations {
    public static int countFilesMatchingPattern(File argDir, String argPattern) {
        if (argDir.isDirectory()) {
            int count = 0;
            for (File file : argDir.listFiles()) {
                if (!file.getName().matches(argPattern)) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    public static int countFilesMatchingPattern(String argPattern) {
        return Evaluations.countFilesMatchingPattern(Evaluations.getWorkingDir(), argPattern);
    }

    public static int countPathsInTreeMatchingPattern(String argRoot, String argPattern) {
        File root;
        if (argRoot != null && !argRoot.isEmpty() && (root = new File(argRoot)).exists()) {
            return Evaluations.countPathsInTreeMatchingPattern(root, argPattern);
        }
        return 0;
    }

    public static String getPathOrDefault(File argDir, String argPattern, String argDefault) {
        if (argDir.isDirectory()) {
            for (File file : argDir.listFiles()) {
                if (!file.getName().matches(argPattern)) continue;
                return file.getAbsolutePath();
            }
        }
        return argDefault;
    }

    public static String getPathOrDefault(String argPattern, String argDefault) {
        return Evaluations.getPathOrDefault(Evaluations.getWorkingDir(), argPattern, argDefault);
    }

    public static boolean hasJCE() {
        try {
            int cipherSpec = Cipher.getMaxAllowedKeyLength("AES/CBC/PKCS5Padding");
            if (cipherSpec >= 256) {
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return false;
    }

    private static int countPathsInTreeMatchingPattern(File argRoot, String argPattern) {
        int n;
        block9: {
            Pattern pattern = Pattern.compile(argPattern);
            IResourceContainer container = ResourceContainerFactory.getResource(argRoot);
            try {
                int count = 0;
                for (IResource res : container) {
                    if (!pattern.matcher(res.getPath()).matches()) continue;
                    ++count;
                }
                n = count;
                if (container == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (container != null) {
                        try {
                            container.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return 0;
                }
            }
            container.close();
        }
        return n;
    }

    private static File getWorkingDir() {
        String userDirString = System.getProperty("user.dir", ".");
        return new File(userDirString);
    }
}

