/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.Target;

public class TargetInput
extends AbstractInputField
implements Target {
    private static final AtomicInteger GLOBAL_INDEX = new AtomicInteger(1);
    private String _target;
    private String _force;
    private String _osSpecific;
    private String _strict;
    private final int _idx = TargetInput.getGlobalIdx();

    public static int getGlobalIdx() {
        return GLOBAL_INDEX.getAndIncrement();
    }

    public static String getLaxOsSpecificSuffix() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("linux") != -1) {
            return "-linux";
        }
        if (osName.indexOf("mac") != -1) {
            return "-mac";
        }
        if (osName.indexOf("windows") != -1) {
            return "-win";
        }
        if (osName.indexOf("solaris") != -1 || osName.indexOf("sunos") != -1) {
            return "-sun";
        }
        return "-other";
    }

    public static String getOsSpecificSuffix() {
        return System.getProperty("os.name");
    }

    public String getForce() {
        return this._force;
    }

    @Override
    public int getIdx() {
        return this._idx;
    }

    public String getOsSpecific() {
        return this._osSpecific;
    }

    public String getOSSpecificTarget() {
        if (TargetInput.isTrue(this._strict)) {
            return this.getStrictTarget();
        }
        return this.getLaxTarget();
    }

    public String getStrict() {
        return this._strict;
    }

    @Override
    public String getTarget() {
        if (TargetInput.isTrue(this._osSpecific)) {
            return this.getOSSpecificTarget();
        }
        return this._target;
    }

    public String getTargetName() {
        return this._target;
    }

    public void setForce(String argForce) {
        this._force = argForce;
    }

    public void setOsSpecific(String argOsSpecific) {
        this._osSpecific = argOsSpecific;
    }

    public void setStrict(String argStrict) {
        this._strict = argStrict;
    }

    public void setTarget(String argTarget) {
        this._target = argTarget;
        this.setProperty(argTarget);
    }

    @Override
    public boolean validate(InstallerContext cxt) throws ValidationException {
        return true;
    }

    @Override
    public boolean validateObject(Consumer<String> argOutputHandler) {
        if (this.getDisplayText() == null) {
            argOutputHandler.accept("Target:displayText must be set");
            return false;
        }
        if (this.getTarget() == null) {
            argOutputHandler.accept("Target:target must be set");
            return false;
        }
        if (!AbstractInputField.optionalBoolean(this.getForce())) {
            argOutputHandler.accept("Target:force must be true or false or null");
            return false;
        }
        if (!AbstractInputField.optionalBoolean(this.getStrict())) {
            argOutputHandler.accept("Target:strict must be true or false or null");
            return false;
        }
        if (!AbstractInputField.optionalBoolean(this.getOsSpecific())) {
            argOutputHandler.accept("Target:osSpecific must be true or false or null");
            return false;
        }
        if (!AbstractInputField.requiredBoolean(this.getDefaultValue())) {
            argOutputHandler.accept("Target:defaultValue must be true or false");
            return false;
        }
        return true;
    }

    private String getLaxTarget() {
        return this._target + TargetInput.getLaxOsSpecificSuffix();
    }

    private String getStrictTarget() {
        return this._target + TargetInput.getOsSpecificSuffix();
    }
}

