/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.LargeSelectInput;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.swing.AbstractSwingOutputFieldRenderer;

public class LargeSelectInputRenderer
extends AbstractSwingOutputFieldRenderer {
    private LargeSelectInput _inputField;
    private final JComboBox<String> _optionCombo = new JComboBox();

    @Override
    public JComponent initComponent(boolean argOverflow) {
        JPanel panel = this.initDefaultPanel(this._inputField.getDisplayText(), this._optionCombo, argOverflow);
        List<LargeSelectInput.Option> options = this._inputField.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            this._optionCombo.addItem(options.get(i).getText());
            if (!options.get(i).getValue().equals(this._inputField.getDefaultValue())) continue;
            this._optionCombo.setSelectedIndex(i);
        }
        this._optionCombo.addItemListener(e -> this._inputField.setEditted(true));
        return panel;
    }

    @Override
    public void renderError() {
        this.getInstallerContext().getMessageRenderer().printMessage(ResourceHelper.getResourceString("notValidSelection"));
        this._optionCombo.requestFocus();
    }

    @Override
    public void setOutputField(AbstractInputField argInputField) {
        this._inputField = (LargeSelectInput)argInputField;
    }

    @Override
    public void updateDefaultValue() {
        if (!this._inputField.isEditted()) {
            String newDefault = this._inputField.getDefaultValue();
            for (int i = 0; i < this._optionCombo.getItemCount(); ++i) {
                if (!newDefault.equals(this._inputField.getOptions().get(i).getValue())) continue;
                this._optionCombo.setSelectedIndex(i);
                break;
            }
        }
    }

    @Override
    public void updateInputField() {
        int selectedIdx = this._optionCombo.getSelectedIndex();
        if (selectedIdx != -1) {
            this._inputField.setValue(this._inputField.getOptions().get(selectedIdx).getValue());
        } else {
            this._inputField.setValue(this._inputField.getDefaultValue());
        }
    }
}

