/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.page.TextPage;
import org.tp23.antinstaller.renderer.swing.AbstractSwingPageRenderer;
import org.tp23.antinstaller.renderer.swing.ClasspathHTMLEditorKit;
import org.tp23.antinstaller.runtime.ConfigurationException;

public class TextPageRenderer
extends AbstractSwingPageRenderer {
    private static final long serialVersionUID = 1L;
    private final JTextPane _textPane = new JTextPane();
    private final StringBuffer _buffer = new StringBuffer();

    @Override
    public void instanceInit() throws IOException, ConfigurationException {
        String resource = ((TextPage)this.getPage()).getHtmlResource();
        try (InputStream in = this.getClass().getResourceAsStream(resource);){
            if (in == null) {
                throw new ConfigurationException("Html page resource is missing:" + resource);
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                String read = null;
                while ((read = br.readLine()) != null) {
                    this._buffer.append(read);
                }
            }
        }
        JLabel defaults = new JLabel();
        this._textPane.setBackground(defaults.getBackground());
        this._textPane.setEditable(false);
        this._textPane.setContentType("text/html");
        ClasspathHTMLEditorKit classpathKit = new ClasspathHTMLEditorKit();
        this._textPane.setEditorKit(classpathKit);
        this._textPane.setAutoscrolls(true);
        String rule = "body{font-family:" + defaults.getFont().getFamily() + ";font-size:" + defaults.getFont().getSize() + "}";
        classpathKit.getStyleSheet().addRule(rule);
        this._textPane.setBorder(BorderFactory.createEmptyBorder());
        JScrollPane scroller = new JScrollPane();
        scroller.setHorizontalScrollBarPolicy(30);
        scroller.setVerticalScrollBarPolicy(20);
        scroller.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
        this.add((Component)scroller, "Center");
        scroller.getViewport().add(this._textPane);
        this.add((Component)scroller, "Center");
    }

    @Override
    public void updateDefaultValues() {
        String parsedHtml = this.getCtx().getInstaller().getResultContainer().getDefaultValue(this._buffer.toString());
        this._textPane.setText(parsedHtml);
        this._textPane.setCaretPosition(0);
    }

    @Override
    public void updateInputFields() {
    }

    @Override
    public boolean validateFields() throws ValidationException {
        return true;
    }
}

