/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.Console;
import java.io.IOException;
import java.util.List;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.ConditionalField;
import org.tp23.antinstaller.renderer.text.SimpleInputPageRenderer;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;
import org.tp23.antinstaller.runtime.ConfigurationException;

public class ConditionalFieldRenderer
implements TextOutputFieldRenderer {
    private InstallerContext _context;

    @Override
    public boolean isAbort() {
        return false;
    }

    @Override
    public void renderError(AbstractInputField field, Console console) throws IOException {
    }

    @Override
    public void renderOutput(AbstractInputField field, Console console) throws ValidationException, InstallException, IOException {
        ConditionalField conditional = (ConditionalField)field;
        try {
            List<AbstractInputField> fields = null;
            if (conditional.getExpression().evaluate()) {
                fields = conditional.getFields();
                SimpleInputPageRenderer.renderFields(this._context, fields, console);
            }
        }
        catch (ConfigurationException configExc) {
            throw new InstallException("Invalid configuration identified [" + conditional.getIfProperty() + "].", configExc);
        }
        catch (ClassNotFoundException clsNotFoundExc) {
            throw new InstallException("Text renderer could not be found!", clsNotFoundExc);
        }
    }

    @Override
    public void setContext(InstallerContext argContext) {
        this._context = argContext;
    }
}

