/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.Console;
import org.tp23.antinstaller.renderer.MessageRenderer;

public class TextMessageRenderer
implements MessageRenderer {
    @Override
    public void printMessage(String message) {
        this.getConsole().format("%s%n", message);
    }

    @Override
    public boolean prompt(String message) {
        String line = this.getConsole().readLine("%s%n", message);
        if (line != null && !"".equals(line) && line.trim().length() > 0) {
            return Character.toUpperCase(line.trim().charAt(0)) == 'Y' || Character.toUpperCase(line.trim().charAt(0)) == 'T';
        }
        return false;
    }

    private Console getConsole() {
        Console con = System.console();
        if (con != null) {
            return con;
        }
        throw new IllegalStateException("Console not found!");
    }
}

