/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.io.File;
import java.net.URL;
import java.util.Map;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.antmod.ProjectHelper3;
import org.tp23.antinstaller.runtime.Logger;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;
import org.tp23.antinstaller.selfextract.InstallerUtil;

public class AntProjectFilter
implements ExecuteFilter {
    public static final String ANTHOME_PROPERTY = "ant.home";

    private static void setAntHome(InstallerContext ctx) {
        String antHomeProperty = System.getProperty(ANTHOME_PROPERTY);
        if (antHomeProperty == null) {
            System.setProperty(ANTHOME_PROPERTY, ctx.getFileRoot().getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exec(InstallerContext ctx) throws InstallException {
        if (ctx.getInstaller().isVerbose()) {
            ctx.log("Starting Ant Project");
        }
        Project project = new Project();
        Throwable error = null;
        try {
            AntProjectFilter.setAntHome(ctx);
            if (ctx.getAntOutputRenderer() != null) {
                project.addBuildListener(ctx.getAntOutputRenderer().getListener());
            }
            InstallerContext.ChainedListener bl = ctx.getBuildListener();
            project.addBuildListener(bl);
            Logger logger = ctx.getLogger();
            if (logger != null) {
                DefaultLogger antFileLogger = new DefaultLogger();
                logger.setLogging(antFileLogger);
                int logLevel = ctx.getInstaller().isDebug() ? 3 : 2;
                antFileLogger.setMessageOutputLevel(logLevel);
                project.addBuildListener(antFileLogger);
            }
            project.setInputHandler(new DefaultInputHandler());
            project.fireBuildStarted();
            project.init();
            project.setUserProperty("ant.version", Main.getAntVersion());
            Map<String, String> properties = ctx.getInstaller().getResultContainer().getAllProperties();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                project.setUserProperty(entry.getKey(), entry.getValue());
            }
            ProjectHelper3 helper = new ProjectHelper3();
            project.addReference("ant.projectHelper", helper);
            File buildXml = new File(ctx.getFileRoot(), ctx.getAntBuildFile());
            if (buildXml.exists()) {
                ((ProjectHelper)helper).parse(project, buildXml);
                project.setUserProperty("ant.file", buildXml.getAbsolutePath());
            } else {
                URL buildIS = this.getClass().getResource("/" + ctx.getAntBuildFile());
                ((ProjectHelper)helper).parse(project, buildIS);
                project.setUserProperty("ant.file", buildIS.toExternalForm());
            }
            File enclosingJar = InstallerUtil.getEnclosingJar(this);
            project.setUserProperty("antinstaller.jar", enclosingJar.getAbsolutePath());
            project.setBaseDir(ctx.getFileRoot());
            project.executeTargets(ctx.getInstaller().getTargets(ctx));
            project.fireBuildFinished(error);
            ctx.setInstallSucceded(error != null);
            ctx.log("Ant finished");
            ctx.getRunner().antFinished();
        }
        catch (Throwable e) {
            try {
                if (!(e instanceof ExitStatusException) || ((ExitStatusException)e).getStatus() != 0) {
                    error = e;
                    throw new InstallException("Error running the install, " + e.getMessage(), e);
                }
                ctx.log(((ExitStatusException)e).getMessage());
                project.fireBuildFinished(error);
                ctx.setInstallSucceded(error != null);
                ctx.log("Ant finished");
                ctx.getRunner().antFinished();
            }
            catch (Throwable throwable) {
                project.fireBuildFinished(error);
                ctx.setInstallSucceded(error != null);
                ctx.log("Ant finished");
                ctx.getRunner().antFinished();
                throw throwable;
            }
        }
    }
}

