/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.io.File;
import java.io.IOException;
import org.tp23.antinstaller.DefaultPropertiesFileRenderer;
import org.tp23.antinstaller.ExplicitPropertiesFileRenderer;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.PropertiesFileRenderer;
import org.tp23.antinstaller.input.ResultContainer;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;

public class PropertyPrinterFilter
implements ExecuteFilter {
    @Override
    public void exec(InstallerContext ctx) throws InstallException {
        ResultContainer results = ctx.getInstaller().getResultContainer();
        results.setProperty("basedir", ctx.getFileRoot().getAbsolutePath());
        this.printProperties(ctx);
        if (ctx.getInstaller().isVerbose()) {
            ctx.log("Properties printed:" + ctx.getFileRoot().getAbsolutePath() + File.separatorChar + "ant.install.properties");
        }
    }

    private void printProperties(InstallerContext ctx) {
        PropertiesFileRenderer propRenderer = ctx.getInstaller().isVerbose() ? new ExplicitPropertiesFileRenderer() : new DefaultPropertiesFileRenderer();
        File currentDir = new File(".");
        ctx.log("auto build supported: " + ctx.getInstaller().supportsAutoBuild());
        boolean alreadyWritten = false;
        if (currentDir.canWrite() && ctx.getInstaller().supportsAutoBuild()) {
            if (ctx.getInstaller().isVerbose()) {
                try {
                    ctx.log("Rendering properties in the current directory: " + currentDir.getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            propRenderer.renderProperties(ctx, currentDir);
            alreadyWritten = true;
        }
        if (!currentDir.equals(ctx.getFileRoot()) || !alreadyWritten) {
            propRenderer.renderProperties(ctx, ctx.getFileRoot());
        }
    }
}

