/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.zip.ZipOutputStream;
import org.tp23.antinstaller.runtime.ConfigurationLoader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Installer
extends Jar {
    public static final String NON_EXTRACTOR = "NonExtractor";
    private boolean _selfExtractor = true;
    private final List<FileSet> _runtimeLibs = new ArrayList<FileSet>();
    private File _installConfig;
    private File _buildFile;
    private String _laf;
    private boolean _failOnError = true;
    private boolean _validateConfig = true;
    private boolean _buildFileSet = false;
    private boolean _configFileSet = false;

    public Installer() {
        this.duplicate = "ignore";
        this.archiveType = "jar";
        this.emptyBehavior = "create";
        this.setEncoding("UTF8");
    }

    public void addRuntime(FileSet fs) {
        this._runtimeLibs.add(fs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        GregorianCalendar c = new GregorianCalendar();
        Date d = c.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE, MMMM d, yyyy KK:mm:ss aa zzz", Locale.getDefault());
        String formattedDateString = sdf.format(d);
        this.log("run by - " + System.getProperty("user.name") + " - " + formattedDateString);
        this.log("java - " + System.getProperty("java.vm.vendor") + " v" + System.getProperty("java.vm.version"));
        this.log("os - " + System.getProperty("os.name") + " v" + System.getProperty("os.version"));
        if (this._validateConfig) {
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.validateConfig();
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
        }
        this.unpackRuntimeLibs();
        super.execute();
    }

    @Override
    public void reset() {
        super.reset();
        this._installConfig = null;
        this._buildFile = null;
    }

    public void setBuildFile(File argBuildFile) {
        this._buildFile = argBuildFile;
        if (!this._buildFile.exists()) {
            throw new BuildException("AntInstall build file: " + argBuildFile + " does not exist.");
        }
        ZipFileSet fs = new ZipFileSet();
        fs.setFile(argBuildFile);
        fs.setFullpath("build.xml");
        super.addFileset(fs);
    }

    public void setExtractType(String argExtractType) {
        this._selfExtractor = !NON_EXTRACTOR.equals(argExtractType);
    }

    public void setFailOnError(boolean fail) {
        this._failOnError = fail;
    }

    public void setInstallConfig(File argIinstallConfig) {
        this._installConfig = argIinstallConfig;
        if (!argIinstallConfig.exists()) {
            throw new BuildException("AntInstall config: " + argIinstallConfig + " does not exist.");
        }
        ZipFileSet fs = new ZipFileSet();
        fs.setFile(argIinstallConfig);
        fs.setFullpath("antinstall-config.xml");
        super.addFileset(fs);
    }

    public void setRuntimePathRef(String pathName) {
        Path path = (Path)this.getProject().getReference(pathName);
        for (Resource pathEntry : path) {
            if (pathEntry instanceof FileResource) {
                FileSet fs = new FileSet();
                fs.setProject(this.getProject());
                fs.setFile(((FileResource)pathEntry).getFile());
                this.log("Adding path entry [" + pathEntry + "] to runtime path.");
                this._runtimeLibs.add(fs);
                continue;
            }
            throw new BuildException("Only file resources are supported in runtimepathref");
        }
    }

    public void setValidateConfig(boolean validate) {
        this._validateConfig = validate;
    }

    @Override
    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        if (this._buildFile == null && !this.isInUpdateMode()) {
            throw new BuildException("buildFile attribute is required", this.getLocation());
        }
        if (this._installConfig == null && !this.isInUpdateMode()) {
            throw new BuildException("installConfig attribute is required", this.getLocation());
        }
        try {
            this.addConfiguredManifest(this.getManifest());
        }
        catch (ManifestException me) {
            throw new BuildException("Cant add AntInstaller Manifest", me, this.getLocation());
        }
        super.initZipOutputStream(zOut);
    }

    protected void readConfig() {
        try {
            this.log("reading config...");
            ConfigurationLoader configurationLoader = new ConfigurationLoader(t -> this.log((String)t));
            configurationLoader.readConfig(this._installConfig.getParentFile(), this._installConfig.getName());
            this._laf = configurationLoader.getInstaller().getLookAndFeel();
        }
        catch (IOException ex) {
            this.log("An error occurred when loading " + this._installConfig + ". " + ex.getMessage(), ex, 0);
            this.err();
        }
    }

    protected void validateConfig() {
        int ret = 1;
        try {
            this.log("Validating configuration file [" + this._installConfig + "]...");
            ConfigurationLoader configurationLoader = new ConfigurationLoader(t -> this.log((String)t));
            configurationLoader.readConfig(this._installConfig.getParentFile(), this._installConfig.getName());
            ret = configurationLoader.validate();
            this._laf = configurationLoader.getInstaller().getLookAndFeel();
            if (ret != 0) {
                this.err();
            }
        }
        catch (Exception ex) {
            this.log("An error occurred when validating " + this._installConfig + ". " + ex.getMessage(), ex, 0);
            this.err();
        }
        try {
            this.log("parsing included build.xml...");
            InputSource xmlInp = new InputSource(this._buildFile.toURI().toString());
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser parser = parserFactory.newSAXParser();
            parser.parse(xmlInp, new DefaultHandler(){

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }
            });
            this.log("build.xml is well formed");
        }
        catch (Exception ex) {
            this.log("An error occurred when parsing " + this._buildFile + ". " + ex.getMessage(), ex, 0);
            this.errNestedBuildXml();
        }
    }

    @Override
    protected void zipFile(InputStream is, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException {
        if ("antinstall-config.xml".equalsIgnoreCase(vPath)) {
            if (this._buildFileSet) {
                this.log("Two antinstall-config.xml files in jar", 1);
            }
            this._buildFileSet = true;
        }
        if ("build.xml".equalsIgnoreCase(vPath)) {
            if (this._configFileSet) {
                this.log("Two build.xml files in jar", 1);
            }
            this._configFileSet = true;
        }
        super.zipFile(is, zOut, vPath, lastModified, fromArchive, mode);
    }

    private void err() {
        String errorMsg = "Error in config file:" + this._installConfig.getAbsolutePath();
        if (this._failOnError) {
            throw new BuildException(errorMsg);
        }
        this.log(errorMsg, 0);
    }

    private void errNestedBuildXml() {
        String errorMsg = "Error in included build file:" + this._buildFile.getAbsolutePath();
        if (this._failOnError) {
            throw new BuildException(errorMsg);
        }
        this.log(errorMsg, 0);
    }

    private String getLaf() {
        if (this._laf == null) {
            return "greymetal";
        }
        return this._laf;
    }

    private Manifest getManifest() throws ManifestException {
        this.log("Creating MANIFEST.mf");
        Manifest newManifest = new Manifest();
        Manifest.Section mainSection = newManifest.getMainSection();
        Manifest.Attribute attmc = new Manifest.Attribute();
        attmc.setName("Main-Class");
        String mainClass = this._selfExtractor ? "org.tp23.antinstaller.selfextract.SelfExtractor" : "org.tp23.antinstaller.selfextract.NonExtractor";
        attmc.setValue(mainClass);
        mainSection.addAttributeAndCheck(attmc);
        Manifest.Attribute attlaf = new Manifest.Attribute();
        attlaf.setName("Look-And-Feel");
        attlaf.setValue(this.getLaf());
        mainSection.addAttributeAndCheck(attlaf);
        return newManifest;
    }

    private void unpackRuntimeLibs() {
        if (this._runtimeLibs.isEmpty()) {
            throw new BuildException("Installer runtime files must be provided via runtime (FileSet) elements.");
        }
        for (FileSet fs : this._runtimeLibs) {
            for (Resource runtimeResource : fs) {
                if (runtimeResource instanceof FileResource) {
                    FileResource file = (FileResource)runtimeResource;
                    ZipFileSet set = new ZipFileSet();
                    set.setSrc(file.getFile());
                    set.setExcludes("META-INF/**");
                    super.addZipfileset(set);
                    continue;
                }
                throw new BuildException("Only file resources can be provided via the runtime element.");
            }
        }
    }
}

