/*
 * Decompiled with CFR 0.152.
 */
package com.micros_retail.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.ResourceDecorator;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipOutputStream;

public class ZipWithDateOverride
extends Zip {
    private final long _overrideTime = System.currentTimeMillis();
    private boolean _overrideTimestamp = false;

    public void setOverrideTimestamp(Boolean bl) {
        this._overrideTimestamp = bl;
    }

    @Override
    protected void zipDir(Resource resource, ZipOutputStream zipOutputStream, String string, int n, ZipExtraField[] zipExtraFieldArray) throws IOException {
        if (this._overrideTimestamp) {
            super.zipDir(new TimeOverrideDecorator(resource, this._overrideTime), zipOutputStream, string, n, zipExtraFieldArray);
        } else {
            super.zipDir(resource, zipOutputStream, string, n, zipExtraFieldArray);
        }
    }

    @Override
    protected void zipFile(InputStream inputStream, ZipOutputStream zipOutputStream, String string, long l, File file, int n) throws IOException {
        if (this._overrideTimestamp) {
            super.zipFile(inputStream, zipOutputStream, string, this._overrideTime, file, n);
        } else {
            super.zipFile(inputStream, zipOutputStream, string, l, file, n);
        }
    }

    private static class TimeOverrideDecorator
    extends ResourceDecorator {
        private final long _lastModified;

        private TimeOverrideDecorator(Resource resource, long l) {
            super(resource);
            this._lastModified = l;
        }

        @Override
        public long getLastModified() {
            return this._lastModified;
        }
    }
}

