/*
 * Decompiled with CFR 0.152.
 */
package oracle.retail.xstore.installer.resource;

import java.io.File;
import java.io.IOException;
import oracle.retail.xstore.installer.resource.IResourceContainer;
import oracle.retail.xstore.installer.resource.impl.DirectoryResourceContainer;
import oracle.retail.xstore.installer.resource.impl.TarResourceContainer;
import oracle.retail.xstore.installer.resource.impl.ZipResourceContainer;

public class ResourceContainerFactory {
    public static IResourceContainer getResource(File argFile) throws IOException {
        String fileName = argFile.getName().toLowerCase();
        if (argFile.isDirectory()) {
            return new DirectoryResourceContainer(argFile);
        }
        if (fileName.endsWith(".zip")) {
            return new ZipResourceContainer(argFile);
        }
        if (fileName.endsWith(".tar")) {
            return new TarResourceContainer(argFile, TarResourceContainer.TarStreamType.RAW);
        }
        if (fileName.endsWith(".tar.gz") || fileName.endsWith(".tgz")) {
            return new TarResourceContainer(argFile, TarResourceContainer.TarStreamType.GZIP);
        }
        if (fileName.endsWith(".tar.bz2")) {
            return new TarResourceContainer(argFile, TarResourceContainer.TarStreamType.BZIP2);
        }
        throw new IllegalArgumentException("Cannot find a suitable resource cotntainer for [" + argFile + "]");
    }
}

