/*
 * Decompiled with CFR 0.152.
 */
package oracle.retail.xstore.installer.resource.impl;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import oracle.retail.xstore.installer.resource.IFileResource;
import oracle.retail.xstore.installer.resource.IResource;
import oracle.retail.xstore.installer.resource.IResourceContainer;
import oracle.retail.xstore.installer.resource.impl.Resource;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class TarResourceContainer
implements IResourceContainer {
    private final File _file;
    private final TarInputStream _stream;

    private static TarInputStream getStream(File argFile, TarStreamType argType) throws MalformedURLException, IOException {
        InputStream readStream = argFile.toURI().toURL().openStream();
        switch (argType) {
            case GZIP: {
                readStream = new GZIPInputStream(readStream);
                break;
            }
            case BZIP2: {
                readStream.skip(2L);
                readStream = new CBZip2InputStream(readStream);
                break;
            }
        }
        return new TarInputStream(readStream);
    }

    public TarResourceContainer(File argTarFile, TarStreamType argType) throws IOException {
        this._file = argTarFile;
        this._stream = TarResourceContainer.getStream(argTarFile, argType);
    }

    @Override
    public void close() throws IOException {
        this._stream.close();
    }

    @Override
    public File getRoot() {
        return this._file;
    }

    @Override
    public Iterator<IResource> iterator() {
        return new TarResourceIterator(this._stream);
    }

    private static class TarResourceIterator
    implements Iterator<IResource> {
        private final TarInputStream _stream;
        private TarEntry _currentEntry;

        TarResourceIterator(TarInputStream argStream) {
            this._stream = argStream;
        }

        @Override
        public boolean hasNext() {
            if (this._currentEntry == null) {
                try {
                    this._currentEntry = this._stream.getNextEntry();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return this._currentEntry != null;
        }

        @Override
        public IResource next() {
            if (this.hasNext()) {
                String rawPath = this._currentEntry.getName();
                boolean directory = this._currentEntry.isDirectory();
                this._currentEntry = null;
                if (directory) {
                    int end = rawPath.lastIndexOf(47);
                    int start = rawPath.lastIndexOf(47, end - 1) + 1;
                    String folderPath = rawPath.substring(0, end);
                    String folderName = rawPath.substring(start, end);
                    return new Resource(folderPath, folderName);
                }
                int afterLastSlashOrZero = rawPath.lastIndexOf(47) + 1;
                String fileName = rawPath.substring(afterLastSlashOrZero);
                return new TarFileResource(rawPath, fileName, this._stream);
            }
            throw new NoSuchElementException();
        }
    }

    private static class TarFileResource
    extends Resource
    implements IFileResource {
        private final TarInputStream _stream;

        public TarFileResource(String argPath, String argName, TarInputStream argStream) {
            super(argPath, argName);
            this._stream = argStream;
        }

        @Override
        public InputStream getInput() {
            return new FilterInputStream(this._stream){

                @Override
                public void close() throws IOException {
                }
            };
        }
    }

    public static enum TarStreamType {
        RAW,
        GZIP,
        BZIP2;

    }
}

