/*
 * Decompiled with CFR 0.152.
 */
package oracle.retail.xstore.installer.task;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.xml.bind.DatatypeConverter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class StringHasherEncoder
extends Task {
    private Charset _charset = StandardCharsets.UTF_8;
    private String _algorithm;
    private String _encoding;
    private String _string;
    private String _property;
    private boolean _trim;

    public static byte[] getBytes(String argInput, String argAlgorithm, Charset argCharset) throws NoSuchAlgorithmException {
        byte[] bytes = argInput.getBytes(argCharset);
        if (argAlgorithm != null) {
            MessageDigest digest = MessageDigest.getInstance(argAlgorithm);
            bytes = digest.digest(bytes);
        }
        return bytes;
    }

    public static String getString(byte[] argBytes, String argEncoding) {
        String normalizedEncoding = argEncoding.trim().toUpperCase();
        if ("BASE64".equals(normalizedEncoding)) {
            return Base64.getEncoder().encodeToString(argBytes);
        }
        if ("HEX".equals(normalizedEncoding)) {
            return DatatypeConverter.printHexBinary(argBytes);
        }
        throw new BuildException("Provided encoding '" + argEncoding + "' is not supported.");
    }

    @Override
    public void execute() throws BuildException {
        if (this._string == null) {
            throw new BuildException("'string' attribute must be provided.");
        }
        if (this._property == null) {
            throw new BuildException("'property' attribute must be provided.");
        }
        if (this._encoding == null) {
            throw new BuildException("'encoding' attribute must be provided.");
        }
        try {
            String input = this._trim ? this._string.trim() : this._string;
            byte[] bytes = StringHasherEncoder.getBytes(input, this._algorithm, this._charset);
            String hashString = StringHasherEncoder.getString(bytes, this._encoding);
            this.getProject().setProperty(this._property, hashString);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new BuildException("Could not use the provided algorithm.", ex);
        }
    }

    public void setAlgorithm(String argAlgorithm) {
        this._algorithm = argAlgorithm;
    }

    public void setCharset(String argCharset) {
        this._charset = Charset.forName(argCharset);
    }

    public void setEncoding(String argEncoding) {
        this._encoding = argEncoding;
    }

    public void setProperty(String argProperty) {
        this._property = argProperty;
    }

    public void setString(String argString) {
        this._string = argString;
    }

    public void setTrim(boolean argTrim) {
        this._trim = argTrim;
    }
}

