/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.ResultContainer;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.swing.SizeHelper;
import org.tp23.antinstaller.runtime.IfPropertyHelper;
import org.tp23.antinstaller.runtime.VersionHelper;
import org.tp23.antinstaller.runtime.exe.ExecuteRunnerFilter;

public class Installer {
    private static ResourceBundle langPack = null;
    private String _name;
    private String _minJavaVersion = "1.4";
    private String _defaultUi = "text-auto";
    private List<String> _ui = Collections.singletonList("text-auto");
    private boolean _verbose;
    private boolean _debug;
    private String _lookAndFeel;
    private String _wide;
    private String _high;
    private String _windowIcon;
    private String _defaultImageResource;
    private String _finishButtonText = "Install";
    private String _loadDefaults;
    private String _version = "0.0";
    private Page[] _pages;
    private final ResultContainer _resultContainer = new ResultContainer();

    public String getDefaultImageResource() {
        return this._defaultImageResource;
    }

    public String getDefaultUi() {
        return this._defaultUi;
    }

    public String getFinishButtonText() {
        if (langPack != null) {
            return langPack.getString("finishButtonText");
        }
        return this._finishButtonText;
    }

    public String getHigh() {
        return this._high;
    }

    public String getLoadDefaults() {
        return this._loadDefaults;
    }

    public String getLookAndFeel() {
        return this._lookAndFeel;
    }

    public String getMinJavaVersion() {
        return this._minJavaVersion;
    }

    public String getName() {
        return this._name;
    }

    public Page[] getPages() {
        return this._pages;
    }

    public ResultContainer getResultContainer() {
        return this._resultContainer;
    }

    public Vector<String> getTargets(InstallerContext ctx) {
        Vector<String> argsList = new Vector<String>();
        for (int i = 0; i < this.getPages().length; ++i) {
            Page page = this.getPages()[i];
            List<Page.IndexedTarget> pageTargets = page.getPageTargets();
            boolean shown = this.conditionalDisplay(page, ctx);
            for (int pt = 0; pt < pageTargets.size(); ++pt) {
                Page.IndexedTarget target = pageTargets.get(pt);
                if (argsList.contains(target.getTarget()) || !shown) continue;
                argsList.add(target.getTarget());
            }
            List<Page.IndexedTarget> elementTargets = page.getElementTargets();
            for (int pt = 0; pt < elementTargets.size(); ++pt) {
                Page.IndexedTarget target = elementTargets.get(pt);
                if (argsList.contains(target.getTarget()) || !shown) continue;
                argsList.add(target.getTarget());
            }
        }
        return argsList;
    }

    public List<String> getUi() {
        return this._ui;
    }

    public String getVersion() {
        return this._version;
    }

    public String getWide() {
        return this._wide;
    }

    public String getWindowIcon() {
        return this._windowIcon;
    }

    public boolean isDebug() {
        return this._debug;
    }

    public boolean isVerbose() {
        return this._verbose;
    }

    public void parseHighValue(String argHigh) throws NumberFormatException, StringIndexOutOfBoundsException {
        int pageHeight = Integer.parseInt(argHigh.substring(0, argHigh.indexOf(58)));
        int labelHeight = Integer.parseInt(argHigh.substring(argHigh.indexOf(58) + 1, argHigh.length()));
        SizeHelper.setPageHeight(pageHeight);
        SizeHelper.setFieldHeight(labelHeight);
    }

    public void parseWideValue(String argWide) throws NumberFormatException, StringIndexOutOfBoundsException {
        int pageWidth = Integer.parseInt(argWide.substring(0, argWide.indexOf(58)));
        int labelWidth = Integer.parseInt(argWide.substring(argWide.indexOf(58) + 1, argWide.length()));
        SizeHelper.setPageWidth(pageWidth);
        SizeHelper.setLabelWidth(labelWidth);
    }

    public void setDebug(boolean argDebug) {
        this._debug = argDebug;
    }

    public void setDebug(String strDebug) {
        this._debug = AbstractInputField.isTrue(strDebug);
    }

    public void setDefaultImageResource(String argDefaultImageResource) {
        this._defaultImageResource = argDefaultImageResource;
    }

    public void setDefaultUi(String argDefaultUi) {
        this._defaultUi = argDefaultUi != null ? argDefaultUi.toLowerCase().trim() : null;
    }

    public void setFinishButtonText(String argFinishButtonText) {
        this._finishButtonText = argFinishButtonText;
    }

    public void setHigh(String argHigh) {
        try {
            this._high = argHigh;
            this.parseHighValue(argHigh);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLoadDefaults(String argLoadDefaults) {
        this._loadDefaults = argLoadDefaults;
    }

    public void setLookAndFeel(String argLookAndFeel) {
        this._lookAndFeel = argLookAndFeel;
    }

    public void setMinJavaVersion(String argMinJavaVersion) throws ExecuteRunnerFilter.AbortException {
        VersionHelper helper;
        if (argMinJavaVersion != null && !"".equals(argMinJavaVersion) && !(helper = new VersionHelper()).equalOrHigher(System.getProperty("java.version"), argMinJavaVersion, true)) {
            throw new ExecuteRunnerFilter.AbortException("Incorrect Java version, installer requires: " + argMinJavaVersion);
        }
        this._minJavaVersion = argMinJavaVersion;
    }

    public void setName(String argName) {
        this._name = argName;
    }

    public void setPages(Page[] argPages) {
        this._pages = argPages;
    }

    public void setUi(String argUi) {
        String[] types = argUi.replaceAll("\\s", "").toLowerCase().split(",");
        this._ui = Arrays.asList(types);
    }

    public void setVerbose(boolean argVerbose) {
        this._verbose = argVerbose;
    }

    public void setVerbose(String strVerbose) {
        this._verbose = AbstractInputField.isTrue(strVerbose);
    }

    public void setVersion(String argVersion) {
        this._version = argVersion;
    }

    public void setWide(String argWide) {
        try {
            this._wide = argWide;
            this.parseWideValue(argWide);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWindowIcon(String argWindowIcon) {
        this._windowIcon = argWindowIcon;
    }

    public boolean supportsAutoBuild() {
        return this._ui != null && this._ui.stream().filter(e -> e.endsWith("-auto")).count() > 0L;
    }

    private boolean conditionalDisplay(Page page, InstallerContext ctx) {
        try {
            IfPropertyHelper helper = new IfPropertyHelper(ctx);
            return helper.ifProperty(page) && helper.ifTarget(page, ctx.getInstaller().getPages());
        }
        catch (InstallException e) {
            throw new IllegalStateException("ifProperty runtime exception", e);
        }
    }

    static {
        try {
            langPack = ResourceBundle.getBundle("resources.LanguagePack");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

