/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.ConditionalField;
import org.tp23.antinstaller.renderer.RendererFactory;
import org.tp23.antinstaller.renderer.swing.AbstractSwingOutputFieldRenderer;
import org.tp23.antinstaller.runtime.ConfigurationException;
import org.tp23.antinstaller.runtime.logic.Expression;

public class ConditionalFieldRenderer
extends AbstractSwingOutputFieldRenderer {
    private final List<AbstractSwingOutputFieldRenderer> _renderers = new ArrayList<AbstractSwingOutputFieldRenderer>();
    private ConditionalField _condField;
    private ConditionalField _outputField;

    @Override
    public JComponent initComponent(boolean argOverflow) {
        this._condField = this._outputField;
        List<AbstractInputField> fields = this._condField.getFields();
        for (AbstractInputField field : fields) {
            try {
                AbstractSwingOutputFieldRenderer renderer = RendererFactory.getSwingRenderer(field);
                renderer.setOutputField(field);
                renderer.setInstallerContext(this.getInstallerContext());
                this._renderers.add(renderer);
            }
            catch (ClassNotFoundException e) {
                this.getInstallerContext().log("Could not find renderer for field " + field.getClass().getSimpleName(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void renderError() {
        int listSize = this._renderers.size();
        for (int i = 0; i < listSize; ++i) {
            AbstractSwingOutputFieldRenderer renderer = this._renderers.get(i);
            renderer.renderError();
        }
    }

    @Override
    public void setOutputField(AbstractInputField argOutputField) {
        this._outputField = (ConditionalField)argOutputField;
    }

    @Override
    public void updateDefaultValue() {
        if (this.expressionIsTrue()) {
            int listSize = this._renderers.size();
            for (int i = 0; i < listSize; ++i) {
                AbstractSwingOutputFieldRenderer renderer = this._renderers.get(i);
                renderer.updateDefaultValue();
            }
        }
    }

    @Override
    public void updateInputField() {
        if (this.expressionIsTrue()) {
            int listSize = this._renderers.size();
            for (int i = 0; i < listSize; ++i) {
                AbstractSwingOutputFieldRenderer renderer = this._renderers.get(i);
                renderer.updateInputField();
            }
        }
    }

    private boolean expressionIsTrue() {
        Expression expr = null;
        try {
            expr = this._condField.getExpression();
        }
        catch (ConfigurationException configExc) {
            this.getInstallerContext().log("Invalid configuration identified [" + this._condField.getIfProperty() + "].", (Throwable)configExc);
            return false;
        }
        return expr.evaluate();
    }
}

