/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.DateInput;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.swing.AbstractSwingOutputFieldRenderer;

public class DateInputRenderer
extends AbstractSwingOutputFieldRenderer {
    private DateInput _inputField;
    private final JTextField _jTextField = new JTextField();
    private final Color _origFore = this._jTextField.getForeground();

    @Override
    public JComponent initComponent(boolean argOverflow) {
        JPanel panel = this.initDefaultPanel(this._inputField.getDisplayText(), this._jTextField, argOverflow);
        this._jTextField.setText(this._inputField.getDefaultValue());
        this._jTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() != '\t') {
                    DateInputRenderer.this.setInputFieldEdited(true);
                }
            }
        });
        this._jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent fe) {
                DateInputRenderer.this.restoreForegroundColor();
            }
        });
        return panel;
    }

    @Override
    public void renderError() {
        MessageRenderer mr = this.getInstallerContext().getMessageRenderer();
        String msg = ResourceHelper.replaceTokens(ResourceHelper.getResourceString("notCorrectFormat"), this._inputField.getDisplayText());
        mr.printMessage(msg + "\n\n " + this._inputField.getDateFormat());
        this._jTextField.requestFocus();
        this._jTextField.setForeground(Color.red);
    }

    @Override
    public void setOutputField(AbstractInputField argInputField) {
        this._inputField = (DateInput)argInputField;
        this._inputField.setValue(this._inputField.getDefaultValue());
    }

    @Override
    public void updateDefaultValue() {
        if (!this._inputField.isEditted()) {
            this._jTextField.setText(this._inputField.getDefaultValue());
        }
    }

    @Override
    public void updateInputField() {
        this._inputField.setValue(this._jTextField.getText());
    }

    protected void restoreForegroundColor() {
        this._jTextField.setForeground(this._origFore);
    }

    protected void setInputFieldEdited(boolean argEdited) {
        this._inputField.setEditted(argEdited);
    }
}

