/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.StringUtils;
import org.tp23.antinstaller.page.ProgressPage;
import org.tp23.antinstaller.renderer.AntOutputRenderer;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.swing.AbstractSwingPageRenderer;
import org.tp23.antinstaller.renderer.swing.ProgressPanel;
import org.tp23.antinstaller.renderer.swing.SizeHelper;
import org.tp23.antinstaller.renderer.swing.SwingInstallerContext;
import org.tp23.gui.widget.LoggingTextArea;

public class ProgressPageRenderer
extends AbstractSwingPageRenderer
implements AntOutputRenderer {
    private static final long serialVersionUID = 1L;
    private static final int MESSAGE_PANEL_HEIGHT = 30;
    private final JPanel _contentPanel = new JPanel();
    private final JTabbedPane _jTabbedPane = new JTabbedPane();
    private final JPanel _messagesPanel = new JPanel();
    private final JToggleButton _jToggleButton = new JToggleButton();
    private final JLabel _feedBackLabel = new JLabel();
    private final LoggerListener _buildListener = new LoggerListener();
    protected final LoggingTextArea _outPanel = new LoggingTextArea();
    protected final LoggingTextArea _errPanel = new LoggingTextArea();
    private boolean _showTargets = true;
    private final JScrollPane _progressScrollPane = new JScrollPane();
    private ProgressPanel _progressPanel;

    @Override
    public BuildListener getListener() {
        return this._buildListener;
    }

    @Override
    public void instanceInit() {
        this._showTargets = ((ProgressPage)this.getPage()).isShowTargets();
        this._contentPanel.setLayout(new BorderLayout());
        this.add((Component)this._contentPanel, "Center");
        this._messagesPanel.setLayout(null);
        Dimension messPanelSize = new Dimension(SizeHelper.getPageWidth(), 30);
        this._messagesPanel.setSize(messPanelSize);
        this._messagesPanel.setPreferredSize(messPanelSize);
        this._messagesPanel.setMaximumSize(messPanelSize);
        this._messagesPanel.setMinimumSize(messPanelSize);
        this._feedBackLabel.setText(ResourceHelper.getResourceString("click") + " " + this.getCtx().getInstaller().getFinishButtonText() + " " + ResourceHelper.getResourceString("toContinue"));
        this._feedBackLabel.setBounds(new Rectangle(115, 7, 272, 22));
        this._jToggleButton.setText(ResourceHelper.getResourceString("showDetails"));
        this._jToggleButton.setBounds(new Rectangle(5, 7, 104, 22));
        this._jToggleButton.setMargin(new Insets(0, 0, 0, 0));
        this._messagesPanel.add((Component)this._jToggleButton, null);
        this._messagesPanel.add((Component)this._feedBackLabel, null);
        this._jToggleButton.addActionListener(e -> {
            if (this._jToggleButton.isSelected()) {
                if (this._showTargets) {
                    this._contentPanel.remove(this._progressScrollPane);
                }
                this._contentPanel.add((Component)this._jTabbedPane, "Center");
                this._contentPanel.doLayout();
                this._contentPanel.repaint();
            } else {
                this._contentPanel.remove(this._jTabbedPane);
                if (this._showTargets) {
                    this._contentPanel.add((Component)this._progressScrollPane, "Center");
                    this._progressScrollPane.revalidate();
                }
                this._contentPanel.doLayout();
                this._contentPanel.repaint();
            }
        });
        this._jToggleButton.setIcon(this.getImage("/icons/showdetails.png"));
        this._contentPanel.add((Component)this._messagesPanel, "North");
        if (this._showTargets) {
            this._progressScrollPane.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
            this._contentPanel.add((Component)this._progressScrollPane, "Center");
        }
        this._jTabbedPane.add(ResourceHelper.getResourceString("output"), this._outPanel);
        this._jTabbedPane.add(ResourceHelper.getResourceString("errors"), this._errPanel);
        this._jTabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._contentPanel.setMaximumSize(new Dimension(SizeHelper.getPageWidth(), Integer.MAX_VALUE));
        this._contentPanel.setMinimumSize(new Dimension(SizeHelper.getPageWidth(), 100));
        this._contentPanel.setPreferredSize(new Dimension(SizeHelper.getPageWidth(), SizeHelper.getPageHeight() - 100));
        this.getNextButton().setEnabled(false);
        this.getFinishButton().setText(this.getCtx().getInstaller().getFinishButtonText());
        this.getFinishButton().setEnabled(true);
    }

    @Override
    public void setContext(SwingInstallerContext argSwingCtx) {
        super.setContext(argSwingCtx);
        if (this._showTargets) {
            this._progressPanel = new ProgressPanel(this.getSwingCtx().getInstallerContext());
            this._progressScrollPane.getViewport().add(this._progressPanel);
            this.getSwingCtx().setProgressPanel(this._progressPanel);
        }
        this.getSwingCtx().setFeedBackLabel(this._feedBackLabel);
    }

    @Override
    public void updateDefaultValues() {
    }

    @Override
    public void updateInputFields() {
    }

    @Override
    public boolean validateFields() {
        return true;
    }

    @Override
    public void writeErr(String argErr) {
        this._errPanel.writeLine(argErr);
    }

    @Override
    public void writeOut(String argOut) {
        this._outPanel.writeLine(argOut);
    }

    private class LoggerListener
    implements BuildListener {
        private static final int INDENTATION_LEVEL = 12;
        private static final int OUTPUT_LEVEL = 2;
        private long _startTime;

        LoggerListener() {
        }

        @Override
        public void buildFinished(BuildEvent event) {
            Throwable error = event.getException();
            LoggingTextArea outputArea = error != null ? ProgressPageRenderer.this._errPanel : ProgressPageRenderer.this._outPanel;
            this.printMessage("", outputArea);
            if (error == null) {
                this.printMessage("BUILD SUCCESSFUL", outputArea);
            } else {
                this.printMessage("BUILD FAILED", outputArea);
                this.printMessage(StringUtils.getStackTrace(error), outputArea);
            }
            if (this._startTime > 0L) {
                this.printMessage("Total time: " + DateUtils.formatElapsedTime(System.currentTimeMillis() - this._startTime), outputArea);
            }
        }

        @Override
        public void buildStarted(BuildEvent event) {
            this._startTime = System.currentTimeMillis();
        }

        @Override
        public void messageLogged(BuildEvent event) {
            LoggingTextArea outputArea;
            int priority = event.getPriority();
            LoggingTextArea loggingTextArea = outputArea = priority == 0 ? ProgressPageRenderer.this._errPanel : ProgressPageRenderer.this._outPanel;
            if (priority <= 2) {
                Throwable ex;
                if (event.getTask() != null) {
                    StringBuilder label = new StringBuilder();
                    label.append('[').append(event.getTask().getTaskName()).append("] ");
                    int size = 12 - label.length();
                    for (int i = 0; i < size; ++i) {
                        label.insert(0, " ");
                    }
                    String labelString = label.toString();
                    String message = event.getMessage();
                    if (message == null) {
                        this.printMessage(labelString, outputArea);
                    } else {
                        try (BufferedReader reader = new BufferedReader(new StringReader(message));){
                            String line = null;
                            while ((line = reader.readLine()) != null) {
                                this.printMessage(labelString + line, outputArea);
                            }
                        }
                        catch (IOException e) {
                            this.printMessage(message, outputArea);
                        }
                    }
                } else if (event.getMessage() != null) {
                    this.printMessage(event.getMessage(), outputArea);
                }
                if ((ex = event.getException()) != null) {
                    this.printMessage(StringUtils.getStackTrace(ex), outputArea);
                }
            }
        }

        @Override
        public void targetFinished(BuildEvent argArg0) {
        }

        @Override
        public void targetStarted(BuildEvent event) {
            if (!event.getTarget().getName().equals("")) {
                this.printMessage("", ProgressPageRenderer.this._outPanel);
                this.printMessage(event.getTarget().getName() + ":", ProgressPageRenderer.this._outPanel);
            }
        }

        @Override
        public void taskFinished(BuildEvent argArg0) {
        }

        @Override
        public void taskStarted(BuildEvent argArg0) {
        }

        protected void printMessage(String message, LoggingTextArea stream) {
            stream.writeLine(message);
        }
    }
}

