/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.ValidatedTextInput;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.swing.AbstractSwingOutputFieldRenderer;

public class ValidatedTextInputRenderer
extends AbstractSwingOutputFieldRenderer {
    private ValidatedTextInput _inputField;
    private final JTextField _jTextField;
    private Color _origFore;

    public ValidatedTextInputRenderer() {
        this(new JTextField());
    }

    public ValidatedTextInputRenderer(JTextField argField) {
        this._jTextField = argField;
        this._origFore = argField.getForeground();
    }

    public ValidatedTextInput getInputField() {
        return this._inputField;
    }

    public JTextField getTextField() {
        return this._jTextField;
    }

    @Override
    public JComponent initComponent(boolean argOverflow) {
        JPanel panel;
        block2: {
            panel = this.initDefaultPanel(this._inputField.getDisplayText(), this._jTextField, argOverflow);
            try {
                this._jTextField.setText(this._inputField.getDefaultValue());
                this._jTextField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent fe) {
                        ValidatedTextInputRenderer.this.restoreForegroundColor();
                    }
                });
                this._jTextField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        if (e.getKeyChar() != '\t') {
                            ValidatedTextInputRenderer.this.setInputFieldEdited(true);
                        }
                    }
                });
            }
            catch (Exception e) {
                this.getInstallerContext().log(e.getMessage());
                if (!this.getInstallerContext().getInstaller().isVerbose()) break block2;
                this.getInstallerContext().log(e);
            }
        }
        return panel;
    }

    @Override
    public void renderError() {
        MessageRenderer mr = this.getInstallerContext().getMessageRenderer();
        String msg = ResourceHelper.replaceTokens(ResourceHelper.getResourceString("notCorrectFormat"), this._inputField.getDisplayText());
        mr.printMessage(msg + "\n\n e.g. " + this._inputField.getDefaultValue());
        this._jTextField.requestFocus();
        this._jTextField.setForeground(Color.red);
    }

    @Override
    public void setOutputField(AbstractInputField argInputField) {
        this._inputField = (ValidatedTextInput)argInputField;
        this._inputField.setValue(this._inputField.getDefaultValue());
    }

    @Override
    public void updateDefaultValue() {
        if (!this._inputField.isEditted()) {
            String value = this._inputField.getDefaultValue();
            if (this._inputField.getInitialValue() != null) {
                value = this._inputField.getInitialValue();
            }
            this._jTextField.setText(value);
        }
    }

    @Override
    public void updateInputField() {
        this._inputField.setValue(this._jTextField.getText());
    }

    protected void restoreForegroundColor() {
        this._jTextField.setForeground(this._origFore);
    }

    protected void setInputFieldEdited(boolean argEdited) {
        this._inputField.setEditted(argEdited);
    }
}

