/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.Console;
import java.io.IOException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.CheckboxInput;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class CheckboxInputRenderer
implements TextOutputFieldRenderer {
    @Override
    public boolean isAbort() {
        return false;
    }

    @Override
    public void renderError(AbstractInputField field, Console console) {
    }

    @Override
    public void renderOutput(AbstractInputField field, Console console) throws IOException {
        CheckboxInput iField = (CheckboxInput)field;
        if (AbstractInputField.isTrue(iField.getForce())) {
            console.format("%s   [%s:%s]%s%n", iField.getDisplayText(), ResourceHelper.getResourceString("_default_"), iField.getDefaultValue(), ResourceHelper.getResourceString("_required_"));
            iField.setValue(iField.getDefaultValue());
            return;
        }
        String input = console.readLine("%s   [%s:%s]: ", iField.getDisplayText(), ResourceHelper.getResourceString("_default_"), iField.getDefaultValue());
        console.format("%n", new Object[0]);
        if (input == null || input.trim().isEmpty()) {
            input = iField.getDefaultValue();
        }
        if (AbstractInputField.isTrue(input)) {
            iField.setValue("true");
        } else {
            iField.setValue("false");
        }
    }

    @Override
    public void setContext(InstallerContext argCtx) {
    }
}

