/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.DirectoryInput;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class DirectoryInputRenderer
implements TextOutputFieldRenderer {
    @Override
    public boolean isAbort() {
        return false;
    }

    @Override
    public void renderError(AbstractInputField field, Console console) throws IOException {
        this.renderOutput(field, console);
    }

    @Override
    public void renderOutput(AbstractInputField field, Console console) throws IOException {
        DirectoryInput iField = (DirectoryInput)field;
        String defaultValue = iField.getDefaultValue(true);
        String input = console.readLine("%s   [%s:%s]: ", iField.getDisplayText(), ResourceHelper.getResourceString("_default_"), defaultValue);
        console.format("%n", new Object[0]);
        if (input == null || input.trim().isEmpty()) {
            if (defaultValue.isEmpty()) {
                iField.setInputResult("");
            } else {
                iField.setInputResult(new File(defaultValue).getAbsolutePath());
            }
        } else {
            iField.setInputResult(new File(input).getAbsolutePath());
        }
    }

    @Override
    public void setContext(InstallerContext argCtx) {
    }
}

