/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.Console;
import java.io.IOException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.SelectInput;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class SelectInputRenderer
implements TextOutputFieldRenderer {
    private InstallerContext _ctx;

    @Override
    public boolean isAbort() {
        return false;
    }

    @Override
    public void renderError(AbstractInputField field, Console console) throws IOException {
        this._ctx.getMessageRenderer().printMessage("Not a valid selection");
        this.renderOutput(field, console);
    }

    @Override
    public void renderOutput(AbstractInputField field, Console console) throws IOException {
        SelectInput iField = (SelectInput)field;
        this.printText(iField, console);
        String input = console.readLine();
        console.format("%n", new Object[0]);
        if (input == null || "".equals(input)) {
            input = iField.getDefaultValue();
        } else {
            try {
                int idx = Integer.parseInt(input.trim());
                input = iField.getOptions().get(idx - 1).getValue();
            }
            catch (Exception numFormatOrIndexOutOfBounds) {
                return;
            }
        }
        iField.setInputResult(input);
    }

    @Override
    public void setContext(InstallerContext argCtx) {
        this._ctx = argCtx;
    }

    private void printText(SelectInput iField, Console console) {
        console.format("%s%n%s%n", iField.getDisplayText(), ResourceHelper.getResourceString("enterNumber"));
        int sequence = 1;
        for (SelectInput.Option option : iField.getOptions()) {
            String defaultVal = iField.getDefaultValue().equals(option.getValue()) ? " [" + ResourceHelper.getResourceString("_default_") + "]" : "";
            console.format("  %d) %s%s%n", sequence++, option.getText(), defaultVal);
        }
    }
}

