/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.Console;
import java.io.IOException;
import java.util.List;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.renderer.RendererFactory;
import org.tp23.antinstaller.renderer.text.AbstractTextPageRenderer;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class SimpleInputPageRenderer
extends AbstractTextPageRenderer {
    public static boolean renderFields(InstallerContext context, List<? extends AbstractInputField> fields, Console console) throws ClassNotFoundException, IOException, ValidationException, InstallException {
        for (int f = 0; f < fields.size(); ++f) {
            AbstractInputField field = fields.get(f);
            String text = field.getExplanatoryText();
            if (text != null) {
                console.format(text + "%n", new Object[0]);
                console.format("%n", new Object[0]);
            }
            TextOutputFieldRenderer frenderer = RendererFactory.getTextRenderer(field);
            frenderer.setContext(context);
            frenderer.renderOutput(field, console);
            if (frenderer.isAbort()) {
                return false;
            }
            while (!field.validate(context)) {
                frenderer.renderError(field, console);
            }
        }
        return true;
    }

    @Override
    public boolean renderPage(Page page) throws InstallException {
        if (page instanceof SimpleInputPage) {
            try {
                return this.renderSimpleInputPage((SimpleInputPage)page);
            }
            catch (ClassNotFoundException ex) {
                throw new InstallException("Cant find acceptable TextField renderer in SimpleInputPageRenderer.renderPage:" + ex.getMessage(), ex);
            }
        }
        throw new InstallException("Wrong Renderer in SimpleInputPageRenderer.renderPage");
    }

    private boolean renderSimpleInputPage(SimpleInputPage page) throws InstallException, ClassNotFoundException, ValidationException {
        try {
            this.printHeader(page);
            List<AbstractInputField> fields = page.getOutputFields();
            return SimpleInputPageRenderer.renderFields(this.getContext(), fields, this.getConsole());
        }
        catch (IOException ex) {
            throw new InstallException("IOException", ex);
        }
    }
}

