/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.runtime.ConfigurationException;
import org.tp23.antinstaller.runtime.logic.Expression;
import org.tp23.antinstaller.runtime.logic.ExpressionBuilder;

public class IfPropertyHelper {
    private final InstallerContext ctx;

    public IfPropertyHelper(InstallerContext argCtx) {
        this.ctx = argCtx;
    }

    public boolean ifProperty(Page next) throws InstallException {
        SimpleInputPage conditionalPage;
        String ifProperty;
        if (next instanceof SimpleInputPage && (ifProperty = (conditionalPage = (SimpleInputPage)next).getIfProperty()) != null) {
            Expression expression;
            try {
                expression = ExpressionBuilder.parseLogicalExpressions(this.ctx.getInstaller().getResultContainer(), ifProperty);
            }
            catch (ConfigurationException configExc) {
                throw new InstallException("Error parsing ifProperty condition for page " + next.getName(), configExc);
            }
            return expression.evaluate();
        }
        return true;
    }

    public boolean ifTarget(Page next, Page[] pages) {
        SimpleInputPage conditionalPage;
        String ifTarget;
        if (next instanceof SimpleInputPage && (ifTarget = (conditionalPage = (SimpleInputPage)next).getIfTarget()) != null) {
            boolean show = false;
            for (Page page : pages) {
                show |= page.isTarget(ifTarget);
            }
            return show;
        }
        return true;
    }
}

