/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import java.io.Console;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.renderer.RendererFactory;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.text.AbstractTextPageRenderer;
import org.tp23.antinstaller.renderer.text.ConsoleOutputRenderer;
import org.tp23.antinstaller.renderer.text.TextMessageRenderer;
import org.tp23.antinstaller.runtime.AbstractAntRunner;
import org.tp23.antinstaller.runtime.IfPropertyHelper;
import org.tp23.antinstaller.runtime.Logger;
import org.tp23.antinstaller.runtime.Runner;

public class TextRunner
extends AbstractAntRunner
implements Runner {
    private final Console _console = System.console();
    private final InstallerContext _ctx;
    private final Installer _installer;
    private final Logger _logger;
    private final IfPropertyHelper _ifHelper;

    public TextRunner(InstallerContext argCtx) {
        super(argCtx);
        this._ctx = argCtx;
        this._installer = argCtx.getInstaller();
        this._logger = argCtx.getLogger();
        argCtx.setMessageRenderer(new TextMessageRenderer());
        argCtx.setAntOutputRenderer(new ConsoleOutputRenderer());
        this._ifHelper = new IfPropertyHelper(argCtx);
    }

    @Override
    public void antFinished() {
        this._console.format("%s%n", ResourceHelper.getResourceString("finished"));
    }

    @Override
    public void awaitUiCompletion() {
    }

    @Override
    public void fatalError() {
        this._console.format("%s%n", ResourceHelper.getResourceString("failed"));
    }

    public InstallerContext getInstallerContext() {
        return this._ctx;
    }

    @Override
    public boolean runInstaller() throws InstallException {
        try {
            return this.renderPages(this._installer.getPages());
        }
        catch (Exception ex) {
            this._logger.log("FATAL exception during installation:" + ex.getMessage());
            this._logger.log(this._installer, (Throwable)ex);
            this._ctx.getMessageRenderer().printMessage(ResourceHelper.getResourceString("installationFailed") + ":" + ex.getMessage());
            throw new InstallException("Installation failed", ex);
        }
    }

    public String toString() {
        return "TextRunner";
    }

    protected IfPropertyHelper getIfHelper() {
        return this._ifHelper;
    }

    private boolean renderPages(Page[] pages) throws ClassNotFoundException, InstallException {
        Page next = null;
        for (int i = 0; i < pages.length; ++i) {
            next = pages[i];
            if (next instanceof SimpleInputPage && (!this._ifHelper.ifTarget(next, pages) || !this._ifHelper.ifProperty(next))) continue;
            AbstractTextPageRenderer renderer = RendererFactory.getTextPageRenderer(next);
            renderer.setContext(this._ctx);
            this._ctx.setCurrentPage(next);
            renderer.renderPage(next);
            if (next.isAbort()) {
                return false;
            }
            this.runPost(next);
        }
        return true;
    }
}

