/*
 * Decompiled with CFR 0.152.
 */
package com.micros_retail.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class TailFile
extends Task {
    private Charset _charset = StandardCharsets.UTF_8;
    private File _fileToTail;
    private String _textToFind;
    private String _failureProperty;
    private long _timeoutMils = 60000L;
    private long _pollingIntervalMills = 1000L;
    private boolean _failIfTextNotFound = true;

    @Override
    public void execute() throws BuildException {
        this.validateInput();
        try (BufferedReader bufferedReader = Files.newBufferedReader(this._fileToTail.toPath(), this._charset);){
            long l = System.currentTimeMillis();
            boolean bl = false;
            while (System.currentTimeMillis() <= l + this._timeoutMils) {
                String string = bufferedReader.readLine();
                if (string != null) {
                    this.log(string);
                    if (!string.contains(this._textToFind)) continue;
                    bl = true;
                    break;
                }
                Thread.sleep(this._pollingIntervalMills);
            }
            if (!bl) {
                if (this._failureProperty != null) {
                    this.getProject().setProperty(this._failureProperty, "true");
                }
                if (this._failIfTextNotFound) {
                    throw new BuildException("Could not find the target text '" + this._textToFind + "' in the allotted time (" + this._timeoutMils / 1000L + "s).");
                }
            }
        }
        catch (IOException | InterruptedException exception) {
            throw new BuildException("An error occurred during file tailing.", exception);
        }
    }

    public void setCharset(String string) {
        this._charset = Charset.forName(string);
    }

    public void setFailIfTextNotFound(boolean bl) {
        this._failIfTextNotFound = bl;
    }

    public void setFailureProperty(String string) {
        this._failureProperty = string;
    }

    public void setFile(File file) {
        this._fileToTail = file;
    }

    public void setPollingInterval(long l) {
        this._pollingIntervalMills = l;
    }

    public void setTextToFind(String string) {
        this._textToFind = string;
    }

    public void setTimeout(long l) {
        this._timeoutMils = l * 1000L;
    }

    public void setTimeoutMillis(long l) {
        this._timeoutMils = l;
    }

    private void validateInput() {
        if (this._fileToTail == null) {
            throw new BuildException("file must not be null!");
        }
        if (this._textToFind == null) {
            throw new BuildException("texttofind must not be null!");
        }
    }
}

