/*
 * Decompiled with CFR 0.152.
 */
package com.micros_retail.ant.compile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.StringTokenizer;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JarFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final FileSystem _output;
    private final Charset _charset;

    public JarFileManager(FileSystem fileSystem, JavaFileManager javaFileManager, Charset charset) {
        super(javaFileManager);
        this._output = fileSystem;
        this._charset = charset;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
        JavaFileObject.Kind kind;
        if (location == StandardLocation.SOURCE_OUTPUT) {
            kind = JavaFileObject.Kind.SOURCE;
        } else if (location == StandardLocation.CLASS_OUTPUT) {
            kind = JavaFileObject.Kind.CLASS;
        } else {
            throw new IllegalArgumentException("Could not accept location " + location);
        }
        Path path = this.getPathForFile(string2);
        return new JarJavaFileObject(path, kind, this._charset);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        Path path = this.getPathForClass(string, kind);
        return new JarJavaFileObject(path, kind, this._charset);
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
        if (fileObject instanceof JarJavaFileObject && fileObject2 instanceof JarJavaFileObject) {
            JarJavaFileObject jarJavaFileObject = (JarJavaFileObject)fileObject;
            JarJavaFileObject jarJavaFileObject2 = (JarJavaFileObject)fileObject2;
            return jarJavaFileObject.getPath().equals(jarJavaFileObject2.getPath());
        }
        return false;
    }

    private Path getPathForClass(String string, JavaFileObject.Kind kind) throws IOException {
        String string2;
        switch (kind) {
            case CLASS: {
                string2 = ".class";
                break;
            }
            case SOURCE: {
                string2 = ".java";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected type " + kind);
            }
        }
        Path path = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            Object object = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                object = (String)object + string2;
            }
            if (path == null) {
                path = this._output.getPath((String)object, new String[0]);
                continue;
            }
            path = path.resolve((String)object);
        }
        if (path.getParent() != null && Files.notExists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        return path;
    }

    private Path getPathForFile(String string) throws IOException {
        Path path = this._output.getPath(string, new String[0]);
        if (path.getParent() != null && Files.notExists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        return path;
    }

    private static class JarJavaFileObject
    implements JavaFileObject {
        private final Path _class;
        private final JavaFileObject.Kind _kind;
        private final Charset _charset;

        JarJavaFileObject(Path path, JavaFileObject.Kind kind, Charset charset) {
            this._class = path;
            this._kind = kind;
            this._charset = charset;
        }

        @Override
        public boolean delete() {
            try {
                return Files.deleteIfExists(this._class);
            }
            catch (IOException iOException) {
                return false;
            }
        }

        @Override
        public Modifier getAccessLevel() {
            return null;
        }

        @Override
        public CharSequence getCharContent(boolean bl) throws IOException {
            try (BufferedReader bufferedReader = Files.newBufferedReader(this._class, this._charset);){
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[8192];
                while ((n = bufferedReader.read(cArray)) != -1) {
                    stringBuffer.append(cArray, 0, n);
                }
                StringBuffer stringBuffer2 = stringBuffer;
                return stringBuffer2;
            }
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return this._kind;
        }

        @Override
        public long getLastModified() {
            try {
                return Files.getLastModifiedTime(this._class, new LinkOption[0]).toMillis();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public String getName() {
            return this._class.toString();
        }

        @Override
        public NestingKind getNestingKind() {
            return null;
        }

        public Path getPath() {
            return this._class;
        }

        @Override
        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            String string2 = string + kind.extension;
            return this._kind.equals((Object)this.getKind()) && this._class.getFileName().toString().endsWith(string2);
        }

        @Override
        public InputStream openInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return Files.newOutputStream(this._class, new OpenOption[0]);
        }

        @Override
        public Reader openReader(boolean bl) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Writer openWriter() throws IOException {
            return Files.newBufferedWriter(this._class, this._charset, new OpenOption[0]);
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.toUri() + "]";
        }

        @Override
        public URI toUri() {
            return this._class.toUri();
        }
    }
}

