/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.antmod;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.antmod.ProjectHelper3;
import org.tp23.antinstaller.antmod.taskdefs.LogTask;
import org.tp23.antinstaller.antmod.taskdefs.MessageTask;
import org.tp23.antinstaller.antmod.taskdefs.PropertyTask;
import org.tp23.antinstaller.selfextract.InstallerUtil;

public class RuntimeLauncher {
    public static final String CONTEXT_REFERENCE = "antinstaller.internal.context";
    private final Map<String, String> allProperties = new HashMap<String, String>();
    private final Project _project = new Project();
    private final InstallerContext _ctx;

    public RuntimeLauncher(InstallerContext argCtx) {
        this._ctx = argCtx;
    }

    public void parseProject() {
        File buildXml;
        this._project.setCoreLoader(this.getClass().getClassLoader());
        this._project.init();
        ProjectHelper3 helper = new ProjectHelper3();
        this._project.addReference("ant.projectHelper", helper);
        if ("/org/tp23/antinstaller/runtime/exe/selfextractor.fconfig" == this._ctx.getConfigResource()) {
            buildXml = new File(this._ctx.getFileRoot(), this._ctx.getAntBuildFile());
            if (!buildXml.exists()) {
                this._ctx.log("No build file found??: " + buildXml);
            }
            ((ProjectHelper)helper).parse(this._project, buildXml);
            this._project.setUserProperty("ant.file", buildXml.getAbsolutePath());
        }
        if ("/org/tp23/antinstaller/runtime/exe/nonextractor.fconfig" == this._ctx.getConfigResource()) {
            URL buildIS = this.getClass().getResource("/" + this._ctx.getAntBuildFile());
            ((ProjectHelper)helper).parse(this._project, buildIS);
            this._project.setUserProperty("ant.file", buildIS.toExternalForm());
            try {
                File enclosingJar = InstallerUtil.getEnclosingJar(this);
                this._project.setUserProperty("antinstaller.jar", enclosingJar.getAbsolutePath());
            }
            catch (IOException e) {
                this._ctx.log("No enclosing jar found");
            }
        }
        if ("/org/tp23/antinstaller/runtime/exe/script.fconfig" == this._ctx.getConfigResource()) {
            buildXml = new File(this._ctx.getFileRoot(), this._ctx.getAntBuildFile());
            ((ProjectHelper)helper).parse(this._project, buildXml);
            if (!buildXml.exists()) {
                this._ctx.log("No build file found??: " + buildXml);
            }
            this._project.setUserProperty("ant.file", buildXml.getAbsolutePath());
        }
        this._project.setBaseDir(this._ctx.getFileRoot());
        this._project.addReference(CONTEXT_REFERENCE, this._ctx);
        this._project.addTaskDefinition("antinstaller-property", PropertyTask.class);
        this._project.addTaskDefinition("antinstaller-message", MessageTask.class);
        this._project.addTaskDefinition("antinstaller-log", LogTask.class);
    }

    public int run(String target) {
        try {
            this._ctx.getLogger().log("internal target execution started:" + target);
            this._project.fireBuildStarted();
            this._project.executeTarget(target);
            this._project.fireBuildFinished(null);
            this._ctx.getLogger().log("internal target execution successful:" + target);
            return 0;
        }
        catch (Throwable t) {
            this._ctx.getLogger().log("internal target execution error:" + target);
            this._ctx.getLogger().log(this._ctx.getInstaller(), t);
            return 1;
        }
    }

    public void updateProps() {
        this.allProperties.clear();
        for (Map.Entry<Object, Object> entry : InstallerContext.getEnvironment().entrySet()) {
            this.allProperties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        this.allProperties.putAll(this._ctx.getInstaller().getResultContainer().getAllProperties());
        for (Map.Entry<Object, Object> entry : this.allProperties.entrySet()) {
            this._project.setUserProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

