/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.io.File;
import java.util.function.Consumer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.AbstractOSSpecificInput;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.ResourceHelper;

public class DirectoryInput
extends AbstractOSSpecificInput {
    private boolean _abort = false;
    private String _create;
    private String _checkExists;

    public String getCheckExists() {
        return this._checkExists;
    }

    public String getCreate() {
        return this._create;
    }

    public boolean isAbort() {
        return this._abort;
    }

    public void setAbort(boolean argAbort) {
        this._abort = argAbort;
    }

    public void setCheckExists(String argCheckExists) {
        this._checkExists = argCheckExists;
    }

    public void setCreate(String argCreate) {
        this._create = argCreate;
    }

    public void setValue(String dir) {
        this.setInputResult(dir);
    }

    @Override
    public boolean validate(InstallerContext cxt) throws ValidationException {
        if (this.getInputResult() == null) {
            return false;
        }
        MessageRenderer mr = cxt.getMessageRenderer();
        String selectedName = this.getInputResult();
        if ("".equals(selectedName)) {
            if (AbstractInputField.isTrue(this._create) || AbstractInputField.isTrue(this._checkExists)) {
                mr.printMessage(ResourceHelper.getResourceString("dirNotExist"));
                return false;
            }
            return true;
        }
        File file = new File(selectedName);
        if (AbstractInputField.isTrue(this._create) && !file.exists()) {
            try {
                boolean ok;
                if (mr.prompt(ResourceHelper.getResourceString("dirNotExistCreate") + "\n" + file.getAbsolutePath()) && !(ok = file.mkdirs())) {
                    mr.printMessage(ResourceHelper.getResourceString("dirNotCreated"));
                }
            }
            catch (Exception ex) {
                mr.printMessage(ResourceHelper.getResourceString("canNotCreateFile") + "\n" + file.getAbsolutePath());
                throw new ValidationException(ResourceHelper.getResourceString("canNotCreateFile"), ex);
            }
        }
        if (!(!AbstractInputField.isTrue(this._checkExists) || file.exists() && file.isDirectory())) {
            mr.printMessage(ResourceHelper.getResourceString("dirNotExist") + "\n" + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    @Override
    public boolean validateObject(Consumer<String> argOutputHandler) {
        if (this.getDisplayText() == null) {
            argOutputHandler.accept("Directory:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            argOutputHandler.accept("Directory:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            argOutputHandler.accept("Directory:defaultValue must be set");
            return false;
        }
        if (this.getDefaultValue().equals("") && (DirectoryInput.isTrue(this.getCreate()) || DirectoryInput.isTrue(this.getCheckExists()))) {
            argOutputHandler.accept("Directory:defaultValue must be set if checkExists or create are true");
            return false;
        }
        if (!AbstractInputField.optionalBoolean(this.getCreate())) {
            argOutputHandler.accept("Directory:create must be true or false or null");
            return false;
        }
        if (!AbstractInputField.optionalBoolean(this.getCheckExists())) {
            argOutputHandler.accept("Directory:checkExists must be true or false or null");
            return false;
        }
        return true;
    }
}

