/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.InputException;

public class ValidatedTextInput
extends AbstractInputField {
    private String _regex;
    private Pattern _pattern;
    private String _initialValue;

    public String getInitialValue() {
        return this._resultContainer.getDefaultValue(this._initialValue);
    }

    public String getRegex() {
        return this._regex;
    }

    public void setInitialValue(String argInitialValue) {
        this._initialValue = argInitialValue;
    }

    public void setRegex(String argRegex) {
        this._regex = argRegex;
        try {
            this._pattern = Pattern.compile(argRegex);
        }
        catch (BuildException ex) {
            throw new InputException("Invalid regex in Validated text input");
        }
    }

    public void setValue(String dir) {
        this.setInputResult(dir);
    }

    @Override
    public boolean validate(InstallerContext cxt) throws ValidationException {
        try {
            if (this.getInputResult() == null) {
                return false;
            }
            String toTest = this.getInputResult();
            Matcher matcher = this._pattern.matcher(toTest);
            return matcher.matches();
        }
        catch (Throwable e) {
            cxt.log(e);
            return false;
        }
    }

    @Override
    public boolean validateObject(Consumer<String> argOutputHandler) {
        if (this.getDisplayText() == null) {
            argOutputHandler.accept("Validated:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            argOutputHandler.accept("Validated:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            argOutputHandler.accept("Validated:defaultValue must be set");
            return false;
        }
        if (this.getRegex() == null) {
            argOutputHandler.accept("Validated:regex must be set");
            return false;
        }
        return true;
    }
}

