/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.TargetInput;
import org.tp23.antinstaller.runtime.IfPropertyHelper;

public class Page {
    private static final ResourceBundle LANG_PACK;
    private final List<AbstractInputField> _outputFields = new ArrayList<AbstractInputField>();
    private final Set<IndexedTarget> _targets = new TreeSet<IndexedTarget>();
    private String _name;
    private String _displayText;
    private String imageResource;
    private boolean _abort;
    private boolean _exit;
    private String _postDisplayTarget;

    public void addOutputField(AbstractInputField argField) {
        this._outputFields.add(argField);
    }

    public void addTarget(int idx, String target) {
        this._targets.add(new IndexedTarget(idx, target, "input"));
    }

    public List<String> getAllTargets() {
        ArrayList<String> results = new ArrayList<String>(this._targets.size());
        for (IndexedTarget idxTarget : this._targets) {
            results.add(idxTarget.getTarget());
        }
        return results;
    }

    public String getDisplayText() {
        if (LANG_PACK != null) {
            return LANG_PACK.getString("page." + this.getName() + ".displayText");
        }
        return this._displayText;
    }

    public List<IndexedTarget> getElementTargets() {
        return this._targets.stream().filter(e -> "input".equals(e.getTargetType())).collect(Collectors.toList());
    }

    public String getImageResource() {
        return this.imageResource;
    }

    public String getName() {
        return this._name;
    }

    public List<AbstractInputField> getOutputFields() {
        return Collections.unmodifiableList(this._outputFields);
    }

    public List<IndexedTarget> getPageTargets() {
        return this._targets.stream().filter(e -> "page".equals(e.getTargetType())).collect(Collectors.toList());
    }

    public String getPostDisplayTarget() {
        return this._postDisplayTarget;
    }

    public List<String> getTargets(InstallerContext ctx) {
        ArrayList<String> results = new ArrayList<String>(this._targets.size());
        try {
            Iterator<IndexedTarget> iter = this._targets.iterator();
            IfPropertyHelper helper = new IfPropertyHelper(ctx);
            while (iter.hasNext()) {
                IndexedTarget idxTarget = iter.next();
                if ("page".equals(idxTarget.getTargetType())) {
                    if (!helper.ifProperty(this) && !helper.ifTarget(this, ctx.getInstaller().getPages())) continue;
                    results.add(idxTarget.getTarget());
                    continue;
                }
                results.add(idxTarget.getTarget());
            }
        }
        catch (InstallException e) {
            ctx.log(ctx.getInstaller().isVerbose(), (Throwable)e);
            throw new IllegalStateException(e);
        }
        return results;
    }

    public boolean isAbort() {
        return this._abort;
    }

    public boolean isExit() {
        return this._exit;
    }

    public boolean isTarget(String target) {
        if (target == null) {
            return false;
        }
        return this._targets.stream().anyMatch(e -> e.getTarget().equals(target));
    }

    public void removeTarget(int idx) {
        this._targets.remove(new IndexedTarget(idx, null));
    }

    public void setAbort(boolean argAbort) {
        this._abort = argAbort;
    }

    public void setDisplayText(String argDisplayText) {
        this._displayText = argDisplayText;
    }

    public void setExit(boolean argExit) {
        this._exit = argExit;
    }

    public void setImageResource(String argImageResource) {
        this.imageResource = argImageResource;
    }

    public void setName(String argName) {
        this._name = argName;
    }

    public void setPostDisplayTarget(String runtimeTarget) {
        this._postDisplayTarget = runtimeTarget;
    }

    public void setTarget(String targetList) {
        StringTokenizer st = new StringTokenizer(targetList, ",");
        while (st.hasMoreTokens()) {
            this._targets.add(new IndexedTarget(TargetInput.getGlobalIdx(), st.nextToken(), "page"));
        }
    }

    static {
        ResourceBundle langPack = null;
        try {
            langPack = ResourceBundle.getBundle("LanguagePack");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        LANG_PACK = langPack;
    }

    public static class IndexedTarget
    implements Comparable<IndexedTarget> {
        private static final String PAGE = "page";
        private static final String INPUT = "input";
        private final int _idx;
        private final String _target;
        private final String _targetType;

        IndexedTarget(int argIdx, String argTarget) {
            this(argIdx, argTarget, INPUT);
        }

        IndexedTarget(int argIdx, String argTarget, String argTargetType) {
            this._idx = argIdx;
            this._target = argTarget;
            this._targetType = argTargetType;
        }

        @Override
        public int compareTo(IndexedTarget argO) {
            return this._idx - argO._idx;
        }

        public boolean equals(Object argTarget) {
            if (argTarget == null || !(argTarget instanceof IndexedTarget)) {
                return false;
            }
            IndexedTarget test = (IndexedTarget)argTarget;
            return test._idx == this._idx;
        }

        public String getTarget() {
            return this._target;
        }

        public String getTargetType() {
            return this._targetType;
        }

        public int hashCode() {
            return this._idx;
        }
    }
}

