/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.renderer.swing.DisplayTextArea;
import org.tp23.antinstaller.renderer.swing.SizeHelper;

public abstract class AbstractSwingOutputFieldRenderer {
    protected final DisplayTextArea _fieldLabel = new DisplayTextArea();
    private InstallerContext _ctx;

    public abstract JComponent initComponent(boolean var1);

    public void renderError() {
    }

    public void setInstallerContext(InstallerContext argCtx) {
        this._ctx = argCtx;
    }

    public abstract void setOutputField(AbstractInputField var1);

    public abstract void updateDefaultValue();

    public void updateInputField() {
    }

    protected InstallerContext getInstallerContext() {
        return this._ctx;
    }

    protected JPanel initDefaultPanel(String argDisplayText, JComponent argInput, boolean argOverflow) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        SpringLayout layout = new SpringLayout();
        panel.setLayout(layout);
        this._fieldLabel.setText(argDisplayText);
        this._fieldLabel.layoutToWidth(SizeHelper.getLabelWidth() - 10);
        panel.add(this._fieldLabel);
        panel.add(argInput);
        layout.putConstraint("North", (Component)this._fieldLabel, 0, "North", (Component)panel);
        layout.putConstraint("West", (Component)this._fieldLabel, 0, "West", (Component)panel);
        layout.putConstraint("North", (Component)argInput, 0, "North", (Component)panel);
        layout.putConstraint("West", (Component)argInput, 0, "East", (Component)this._fieldLabel);
        layout.putConstraint("East", (Component)argInput, 0, "East", (Component)panel);
        this.initDimensions(panel, argInput, argOverflow);
        return panel;
    }

    protected void initDimensions(JPanel panel, JComponent argInput, boolean argOverflow) {
        int labelHeight = this._fieldLabel.getPreferredSize().height;
        int inputHeight = argInput.getPreferredSize().height;
        int targetHeight = Math.max(labelHeight, inputHeight) + 2;
        int targetWidth = SizeHelper.getPageContentWidth(argOverflow);
        Dimension rowSize = new Dimension(targetWidth, targetHeight);
        panel.setPreferredSize(rowSize);
    }
}

