/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.Target;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.renderer.swing.SizeHelper;

public class ProgressPanel
extends JPanel
implements Scrollable {
    private static final long serialVersionUID = 1L;
    public static final int T_HEIGHT = 19;
    public static final int LEFT_INDENT = 15;
    public static final int DONE = 0;
    public static final int INPROGRESS = 1;
    public static final int TODO = 2;
    private static final Color PROGRESS_COLOR = new Color(0, 125, 0);
    private static final Font MAIN_FONT = new Font("Dialog", 0, 11);
    private static final Font SUB_FONT = new Font("Dialog", 0, 10);
    private List<ProgressModel> _targets = null;
    private final InstallerContext _ctx;
    private ProgressModel _currentPM = null;

    public ProgressPanel(InstallerContext argCtx) {
        super(true);
        this._ctx = argCtx;
    }

    public void buildFinished() {
        this.setToDone(this._targets);
        this.repaint();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 57;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 19;
    }

    @Override
    public Dimension getSize() {
        if (this._targets == null) {
            return new Dimension(SizeHelper.getPageWidth(), 95);
        }
        int count = this._targets.size();
        for (ProgressModel pmodel : this._targets) {
            count += pmodel.subTargets.size();
        }
        return new Dimension(SizeHelper.getPageWidth(), count * 19);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this._targets == null) {
            return;
        }
        Iterator<ProgressModel> iter = this._targets.iterator();
        int offset = 0;
        int i = 1;
        while (iter.hasNext()) {
            ProgressModel pmodel = iter.next();
            this.drawTarget(pmodel, (Graphics2D)g, offset, i < this._targets.size(), i > 1);
            offset += 19;
            offset += pmodel.subTargets.size() * 19;
            ++i;
        }
    }

    public void prepareCalledTargets() {
        Vector<String> targetStrings = this._ctx.getInstaller().getTargets(this._ctx);
        Iterator iter = targetStrings.iterator();
        this._targets = new ArrayList<ProgressModel>();
        while (iter.hasNext()) {
            String tgt = (String)iter.next();
            this._targets.add(new ProgressModel(tgt));
        }
        this.setSize(this.getSize());
        this.revalidate();
        this.repaint();
    }

    public void targetFinished() {
        this._currentPM.setState(0);
    }

    public void targetStarted(BuildEvent buildEvent) {
        try {
            Target tgt = buildEvent.getTarget();
            ProgressModel pm = this._targets.get(this._targets.size() - 1);
            pm.setState(1);
            if (tgt.getName().equals(pm.getName())) {
                this._currentPM = pm;
                this.revalidate();
                this.repaint();
            } else {
                ProgressModel dependency = new ProgressModel(tgt.getName());
                dependency.setState(1);
                if (this._currentPM != null) {
                    this._currentPM.setState(0);
                }
                this._currentPM = dependency;
                pm.subTargets.add(dependency);
                this.setSize(this.getSize());
                this.revalidate();
                this.repaint();
            }
        }
        catch (Exception e) {
            this._ctx.log(e);
        }
    }

    private void drawSubTarget(ProgressModel target, Graphics2D g, int yOffset, boolean hasMore) {
        g.setFont(SUB_FONT);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.gray);
        g.drawLine(23, yOffset, 23, yOffset + 8);
        if (hasMore) {
            g.drawLine(23, 9 + yOffset, 23, 19 + yOffset);
        }
        int xOffset = 15;
        g.drawLine(23, 8 + yOffset, 15 + xOffset + 4, 8 + yOffset);
        if (target.getState() == 0) {
            g.setColor(Color.darkGray);
        }
        if (target.getState() == 1) {
            g.setColor(PROGRESS_COLOR);
        }
        if (target.getState() == 2) {
            g.setColor(Color.gray);
        }
        g.fillRoundRect(15 + xOffset + 4, yOffset + 5, 9, 7, 7, 7);
        g.setColor(Color.black);
        g.drawString(target.getName(), 15 + xOffset + 15, 12 + yOffset);
    }

    private void drawTarget(ProgressModel target, Graphics2D g, int argYOffset, boolean hasMore, boolean hasPrev) {
        int yOffset = argYOffset;
        g.setFont(MAIN_FONT);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.gray);
        if (hasPrev) {
            g.drawLine(23, yOffset, 23, yOffset + 8);
        }
        if (hasMore || !target.subTargets.isEmpty()) {
            g.drawLine(23, 9 + yOffset, 23, 19 + yOffset);
        }
        int xOffset = 0;
        g.drawLine(23, 8 + yOffset, 15 + xOffset + 20, 8 + yOffset);
        if (target.getState() == 0) {
            g.setColor(Color.darkGray);
        }
        if (target.getState() == 1) {
            g.setColor(PROGRESS_COLOR);
        }
        if (target.getState() == 2) {
            g.setColor(Color.gray);
        }
        g.fillRoundRect(15 + xOffset + 3, yOffset + 4, 11, 9, 7, 7);
        g.setColor(Color.black);
        g.drawString(target.getName(), 15 + xOffset + 22, 13 + yOffset);
        if (!target.subTargets.isEmpty()) {
            Iterator<ProgressModel> iter = target.subTargets.iterator();
            int i = 1;
            while (iter.hasNext()) {
                this.drawSubTarget(iter.next(), g, yOffset += 19, hasMore | i < target.subTargets.size());
                ++i;
            }
        }
    }

    private void setToDone(List<ProgressModel> pModels) {
        if (pModels == null || pModels.isEmpty()) {
            return;
        }
        for (ProgressModel pm : pModels) {
            pm.setState(0);
            this.setToDone(pm.subTargets);
        }
    }

    public static class ProgressModel {
        private final String _name;
        private int _state = 2;
        List<ProgressModel> subTargets = new ArrayList<ProgressModel>();

        public ProgressModel(String argName) {
            this._name = argName;
        }

        public String getName() {
            return this._name;
        }

        public int getState() {
            return this._state;
        }

        public void setState(int argState) {
            this._state = argState;
        }

        int getHeight() {
            return 19 + this.subTargets.size() * 19;
        }
    }
}

