/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing.plaf;

import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.renderer.swing.plaf.ModMetalLookAndFeel;

public class LookAndFeelFactory {
    public static final String DEFAULT_LAF = "greymetal";
    public static final String NATIVE_LAF = "native";
    private final String _specifiedLAF;
    private final InstallerContext _ctx;

    public static String getLafFromToken(String token) {
        if (NATIVE_LAF.equals(token)) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        return ModMetalLookAndFeel.class.getName();
    }

    public LookAndFeelFactory(InstallerContext argCtx) {
        this._ctx = argCtx;
        this._specifiedLAF = argCtx.getInstaller().getLookAndFeel();
    }

    public void setLAF() {
        String lafClassName = null;
        try {
            lafClassName = LookAndFeelFactory.getLafFromToken(this._specifiedLAF);
            if (lafClassName == null) {
                return;
            }
            LookAndFeel look = (LookAndFeel)Class.forName(lafClassName).newInstance();
            this._ctx.log("Setting look and feel:" + lafClassName);
            UIManager.setLookAndFeel(look);
        }
        catch (Exception ex) {
            this._ctx.getLogger().log("Can not correctly set Look And Feel:" + ex.getMessage());
            this._ctx.getLogger().log(this._ctx.getInstaller(), (Throwable)ex);
        }
    }
}

