/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.Console;
import java.io.IOException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.DateInput;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class DateInputRenderer
implements TextOutputFieldRenderer {
    @Override
    public boolean isAbort() {
        return false;
    }

    @Override
    public void renderError(AbstractInputField field, Console console) throws IOException {
        DateInput iField = (DateInput)field;
        console.format("The input is not in the correct format:%s%n", iField.getDateFormat());
        this.renderOutput(field, console);
    }

    @Override
    public void renderOutput(AbstractInputField field, Console console) throws IOException {
        DateInput iField = (DateInput)field;
        String input = console.readLine("%s   [%s:%s]: ", field.getDisplayText(), ResourceHelper.getResourceString("_default_"), iField.getDefaultValue());
        console.format("%n", new Object[0]);
        if (input == null || "".equals(input)) {
            input = iField.getDefaultValue();
        }
        iField.setInputResult(input);
    }

    @Override
    public void setContext(InstallerContext argCtx) {
    }
}

