/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.Console;
import java.io.IOException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.TargetInput;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class TargetInputRenderer
implements TextOutputFieldRenderer {
    private InstallerContext _ctx;

    @Override
    public boolean isAbort() {
        return false;
    }

    @Override
    public void renderError(AbstractInputField field, Console console) {
    }

    @Override
    public void renderOutput(AbstractInputField field, Console console) throws IOException {
        TargetInput iField = (TargetInput)field;
        console.format("Install the following component?%n", new Object[0]);
        if (AbstractInputField.isTrue(iField.getForce())) {
            console.format("%s   [%s:%s]%s%n", iField.getDisplayText(), ResourceHelper.getResourceString("_default_"), iField.getDefaultValue(), ResourceHelper.getResourceString("_required_"));
            iField.setInputResult("true");
            return;
        }
        String input = console.readLine("%s   [%s:%s]: ", iField.getDisplayText(), ResourceHelper.getResourceString("_default_"), iField.getDefaultValue());
        console.format("%n", new Object[0]);
        if (input == null || input.trim().equals("")) {
            input = iField.getDefaultValue();
        }
        if (AbstractInputField.isTrue(input)) {
            this._ctx.getCurrentPage().addTarget(iField.getIdx(), iField.getTarget());
            iField.setInputResult("true");
        } else {
            this._ctx.getCurrentPage().removeTarget(iField.getIdx());
            iField.setInputResult("false");
        }
    }

    @Override
    public void setContext(InstallerContext argCtx) {
        this._ctx = argCtx;
    }
}

