/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.TextPage;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.text.AbstractTextPageRenderer;
import org.tp23.antinstaller.renderer.text.Pager;

public class TextPageRenderer
extends AbstractTextPageRenderer {
    private static final String NEXT_CHAR = ResourceHelper.getResourceString("nextChar");

    @Override
    public boolean renderPage(Page page) throws InstallException {
        if (page instanceof TextPage) {
            TextPage lPage = (TextPage)page;
            return this.renderTextPage(lPage);
        }
        throw new InstallException("Wrong Renderer in TextPageRenderer.renderPage");
    }

    private String getNextInstructions() {
        return ResourceHelper.getResourceString("license_next");
    }

    private boolean renderTextPage(TextPage page) throws InstallException {
        try {
            StringBuffer sb = new StringBuffer();
            String resource = page.getTextResource();
            try (InputStream textin = this.getClass().getResourceAsStream(resource);
                 BufferedReader textReader = new BufferedReader(new InputStreamReader(textin, StandardCharsets.UTF_8));){
                this.printHeader(page);
                String lineread = null;
                while ((lineread = textReader.readLine()) != null) {
                    sb.append(lineread);
                    sb.append('\n');
                }
            }
            String parsedText = this.getContext().getInstaller().getResultContainer().getDefaultValue(sb.toString());
            String command = null;
            Pager pager = new Pager(parsedText);
            while (pager.next(this.getConsole())) {
                this.getConsole().format("%n", new Object[0]);
                command = this.getConsole().readLine("%s: ", this.getNextInstructions());
                if (command.toUpperCase().startsWith(NEXT_CHAR)) continue;
            }
            pager.rest(this.getConsole());
            for (int i = 0; i < 80; ++i) {
                this.getConsole().format("~", new Object[0]);
            }
            this.getConsole().format("%n", new Object[0]);
            this.getConsole().readLine(ResourceHelper.getResourceString("clickViewText"), new Object[0]);
            return true;
        }
        catch (IOException ex) {
            throw new InstallException("Not able to read text file", ex);
        }
    }
}

