/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.Console;
import java.io.IOException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.ValidatedTextInput;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class ValidatedTextInputRenderer
implements TextOutputFieldRenderer {
    @Override
    public boolean isAbort() {
        return false;
    }

    @Override
    public void renderError(AbstractInputField field, Console console) throws IOException {
        console.format("The input is not of the correct format%n", new Object[0]);
        this.renderOutput(field, console);
    }

    @Override
    public void renderOutput(AbstractInputField field, Console console) throws IOException {
        ValidatedTextInput iField = (ValidatedTextInput)field;
        String initialValue = iField.getDefaultValue();
        if (iField.getInitialValue() != null) {
            initialValue = iField.getInitialValue();
        }
        String input = console.readLine("%s   [%s:%s]: ", field.getDisplayText(), ResourceHelper.getResourceString("_default_"), initialValue);
        console.format("%n", new Object[0]);
        if (input == null || "".equals(input)) {
            input = initialValue;
        }
        iField.setInputResult(input);
    }

    @Override
    public void setContext(InstallerContext argCtx) {
    }
}

