/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.selfextract;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;

public final class InstallerUtil {
    public static int deleteRecursive(File argDirOrFile) {
        if (!argDirOrFile.exists()) {
            return 0;
        }
        int count = 0;
        if (argDirOrFile.isDirectory()) {
            for (File file : argDirOrFile.listFiles()) {
                count += InstallerUtil.deleteRecursive(file);
            }
        }
        argDirOrFile.delete();
        return ++count;
    }

    public static File getEnclosingJar(Object reference) throws IOException {
        try {
            URL thisJar = reference.getClass().getProtectionDomain().getCodeSource().getLocation();
            File thisFile = new File(thisJar.toURI());
            if (!thisFile.exists()) {
                throw new FileNotFoundException("Could not successfully locate installer content.");
            }
            return thisFile;
        }
        catch (URISyntaxException ex) {
            throw new IOException("Failed to locate enclosing jar.", ex);
        }
    }

    public static File makeTempDir() throws IOException {
        String tempDir = System.getProperty("java.io.tmpdir");
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            File extractDir = new File(tempDir, "antinstall" + i);
            if (extractDir.exists() || !extractDir.mkdirs()) continue;
            extractDir.deleteOnExit();
            return extractDir;
        }
        throw new IOException("Could not create a new temporary directory in " + tempDir);
    }

    private InstallerUtil() {
    }
}

