/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.selfextract;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.concurrent.FutureTask;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.renderer.swing.plaf.LookAndFeelFactory;
import org.tp23.antinstaller.runtime.ExecInstall;
import org.tp23.antinstaller.runtime.exe.FilterChain;
import org.tp23.antinstaller.runtime.exe.FilterFactory;
import org.tp23.antinstaller.selfextract.InstallerUtil;
import org.tp23.antinstaller.selfextract.ProgressIndicator;

public final class SelfExtractor {
    public static final String SELFEXTRACT_CONFIG_RESOURCE = "/org/tp23/antinstaller/runtime/exe/selfextractor.fconfig";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private boolean _overwrite = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        boolean isGraphical = SelfExtractor.testX();
        int returnValue = 1;
        try {
            File tempDir = InstallerUtil.makeTempDir();
            try {
                try {
                    boolean verbose = false;
                    SelfExtractor extractor = new SelfExtractor();
                    File archiveFile = InstallerUtil.getEnclosingJar(extractor);
                    extractor.extract(verbose, isGraphical, archiveFile, tempDir);
                }
                catch (IOException ex) {
                    System.err.println("Could not extract Jar file to directory:" + tempDir);
                    ex.printStackTrace();
                }
                try {
                    FilterChain chain = FilterFactory.factory(SELFEXTRACT_CONFIG_RESOURCE);
                    ExecInstall installExec = new ExecInstall(chain);
                    installExec.parseArgs(args, false);
                    installExec.setInstallRoot(tempDir);
                    returnValue = installExec.exec();
                    installExec.awaitCompletion();
                }
                catch (InstallException ex) {
                    System.err.println("Cant load filter chain: /org/tp23/antinstaller/runtime/exe/selfextractor.fconfig");
                    ex.printStackTrace();
                }
            }
            finally {
                InstallerUtil.deleteRecursive(tempDir);
            }
        }
        catch (IOException ex) {
            System.err.println("Could not successfully create a temporary directory.");
            ex.printStackTrace();
        }
        catch (Throwable ex) {
            System.err.println("An unexpected error occurred during installation.");
            ex.printStackTrace();
        }
        System.exit(returnValue);
    }

    public static void setLaf(Manifest argManifest) {
        String lookAndFeelClass;
        String lookAndFeel;
        Attributes attributes;
        if (argManifest != null && (attributes = argManifest.getMainAttributes()) != null && (lookAndFeel = attributes.getValue("Look-And-Feel")) != null && (lookAndFeelClass = LookAndFeelFactory.getLafFromToken(lookAndFeel)) != null) {
            try {
                UIManager.setLookAndFeel(lookAndFeelClass);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                System.err.println("Could not set requested '" + lookAndFeel + "' look and feel.");
                ex.printStackTrace();
            }
        }
    }

    public static boolean testX() {
        try {
            GraphicsEnvironment.getLocalGraphicsEnvironment();
            boolean headless = GraphicsEnvironment.isHeadless();
            if (headless) {
                return false;
            }
        }
        catch (HeadlessException e) {
            return false;
        }
        return true;
    }

    public void extract(boolean vebose, boolean argIsGraphical, File argArchiveFile, File extractDir) throws FileNotFoundException, IOException {
        try (JarFile file = new JarFile(argArchiveFile);){
            SelfExtractor.setLaf(file.getManifest());
            int fileCount = file.size();
            ProgressIndicator indicator = null;
            if (argIsGraphical) {
                try {
                    FutureTask<ProgressIndicator> task = new FutureTask<ProgressIndicator>(() -> {
                        ProgressIndicator newIndicator = new ProgressIndicator(fileCount);
                        newIndicator.setVisible(true);
                        return newIndicator;
                    });
                    SwingUtilities.invokeAndWait(task);
                    indicator = task.get();
                }
                catch (Exception task) {
                    // empty catch block
                }
            }
            Enumeration<JarEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                Console con;
                JarEntry entry = entries.nextElement();
                if (vebose && (con = System.console()) != null) {
                    con.format("Extracting:%s%n", entry.getName());
                }
                if (entry.isDirectory()) {
                    this.createPath(extractDir, entry.getName());
                } else {
                    try (InputStream stream = file.getInputStream(entry);){
                        this.extract(stream, entry, extractDir);
                    }
                }
                if (indicator == null) continue;
                ProgressIndicator finalIndicator = indicator;
                finalIndicator.tick();
            }
            if (indicator != null) {
                ProgressIndicator finalIndicator = indicator;
                SwingUtilities.invokeLater(() -> finalIndicator.setVisible(false));
            }
        }
    }

    public boolean isOverwrite() {
        return this._overwrite;
    }

    public void setOverwrite(boolean argOverwrite) {
        this._overwrite = argOverwrite;
    }

    private void createPath(File extractDir, String entryName) throws IOException {
        String firstPath;
        File dir;
        int slashIdx = entryName.lastIndexOf(47);
        if (slashIdx >= 0 && !(dir = new File(extractDir, firstPath = entryName.substring(0, slashIdx))).exists() && !dir.mkdirs()) {
            throw new IOException("Could not create directory " + dir);
        }
    }

    private void extract(InputStream zis, JarEntry entry, File extractDir) throws FileNotFoundException, IOException {
        this.createPath(extractDir, entry.getName());
        File fileToUse = new File(extractDir, entry.getName());
        if (fileToUse.exists() && !this._overwrite) {
            return;
        }
        try (FileOutputStream bos = new FileOutputStream(fileToUse);){
            byte[] bytes = new byte[8192];
            int len = 0;
            while ((len = zis.read(bytes)) >= 0) {
                ((OutputStream)bos).write(bytes, 0, len);
            }
            return;
        }
    }
}

