/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.InputException;

public class DateInput
extends AbstractInputField {
    private String _dateFormat = "dd/MM/yyyy";
    private DateFormat _formatter = new SimpleDateFormat(this._dateFormat);

    public DateInput() {
        this._formatter.setLenient(false);
    }

    public String getDateFormat() {
        return this._dateFormat;
    }

    public void setDateFormat(String argDateFormat) {
        try {
            this._formatter = new SimpleDateFormat(argDateFormat);
            this._formatter.setLenient(false);
            this._dateFormat = argDateFormat;
        }
        catch (RuntimeException e) {
            throw new InputException("Invalid date format in DateInput", e);
        }
    }

    @Override
    public void setDefaultValue(String argDefaultValue) {
        this._defaultValue = "TODAY".equals(argDefaultValue) ? this._formatter.format(new Date()) : argDefaultValue;
    }

    public void setValue(String dir) {
        this.setInputResult(dir);
    }

    @Override
    public boolean validate(InstallerContext cxt) throws ValidationException {
        if (this.getInputResult() == null) {
            return false;
        }
        String toTest = this.getInputResult();
        try {
            this._formatter.parse(toTest);
        }
        catch (ParseException ex) {
            return false;
        }
        return true;
    }

    @Override
    public boolean validateObject(Consumer<String> argOutputHandler) {
        if (this.getDisplayText() == null) {
            argOutputHandler.accept("Date:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            argOutputHandler.accept("Date:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            argOutputHandler.accept("Date:defaultValue must be set");
            return false;
        }
        return true;
    }
}

