/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.io.File;
import java.util.function.Consumer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.AbstractOSSpecificInput;

public class FileInput
extends AbstractOSSpecificInput {
    private boolean _abort = false;
    private String _checkExists;

    public String getCheckExists() {
        return this._checkExists;
    }

    public boolean isAbort() {
        return this._abort;
    }

    public void setAbort(boolean argAbort) {
        this._abort = argAbort;
    }

    public void setCheckExists(String argCheckExists) {
        this._checkExists = argCheckExists;
    }

    public void setValue(String dir) {
        this.setInputResult(dir);
    }

    @Override
    public boolean validate(InstallerContext ctx) throws ValidationException {
        File file;
        if (this.getInputResult() == null) {
            return false;
        }
        return !AbstractInputField.isTrue(this._checkExists) || (file = new File(this.getInputResult())).exists();
    }

    @Override
    public boolean validateObject(Consumer<String> argOutputHandler) {
        if (this.getDisplayText() == null) {
            argOutputHandler.accept("File:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            argOutputHandler.accept("File:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            argOutputHandler.accept("File:defaultValue must be set");
            return false;
        }
        if (!AbstractInputField.optionalBoolean(this.getCheckExists())) {
            argOutputHandler.accept("File:checkExists must be true or false or null");
            return false;
        }
        return true;
    }
}

