/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.swing.PageCompletionListener;
import org.tp23.antinstaller.renderer.swing.SizeHelper;
import org.tp23.antinstaller.renderer.swing.SwingInstallerContext;
import org.tp23.antinstaller.runtime.ConfigurationException;

public abstract class AbstractSwingPageRenderer
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final BorderLayout _borderLayout1 = new BorderLayout();
    private final JPanel _controlPanel = new JPanel();
    private final JButton _backButton = new JButton();
    private final JButton _cancelButton = new JButton();
    private final JButton _nextButton = new JButton();
    private final JButton _finishButton = new JButton();
    private final JPanel _titlePanel = new JPanel();
    private final JLabel _titleLabel = new JLabel();
    private final JLabel _imagePanel = new JLabel();
    private final GridLayout _titleLayout = new GridLayout();
    private Page _page;
    private SwingInstallerContext _swingCtx;
    private InstallerContext _ctx;
    private PageCompletionListener _listener;

    public JButton getBackButton() {
        return this._backButton;
    }

    public JButton getCancelButton() {
        return this._cancelButton;
    }

    public JPanel getControlPanel() {
        return this._controlPanel;
    }

    public InstallerContext getCtx() {
        return this._ctx;
    }

    public JButton getFinishButton() {
        return this._finishButton;
    }

    public JLabel getImagePanel() {
        return this._imagePanel;
    }

    public JButton getNextButton() {
        return this._nextButton;
    }

    public Page getPage() {
        return this._page;
    }

    public SwingInstallerContext getSwingCtx() {
        return this._swingCtx;
    }

    public JLabel getTitleLabel() {
        return this._titleLabel;
    }

    public abstract void instanceInit() throws IOException, ConfigurationException, ClassNotFoundException;

    public void setContext(SwingInstallerContext argSwingCtx) {
        this._ctx = argSwingCtx.getInstallerContext();
        this._swingCtx = argSwingCtx;
    }

    public void setPage(Page argPage) {
        block2: {
            this._page = argPage;
            try {
                this.setDoubleBuffered(true);
                CompoundBorder bevelBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 15, 2, 2));
                CompoundBorder tripleBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 4, 1, 4), bevelBorder);
                this.setLayout(this._borderLayout1);
                this._titleLabel.setBorder(tripleBorder);
                this._controlPanel.setBorder(tripleBorder);
                this.add((Component)this._titlePanel, "North");
                this.add((Component)this._controlPanel, "South");
                this._titlePanel.add((Component)this._imagePanel, null);
                this._titlePanel.add((Component)this._titleLabel, null);
                this._titlePanel.setLayout(this._titleLayout);
                this._titleLayout.setColumns(1);
                this._titleLayout.setHgap(0);
                this._titleLayout.setRows(2);
                this._titleLayout.setVgap(2);
                this._titlePanel.setMinimumSize(new Dimension(SizeHelper.getPageWidth(), 75));
                this._titlePanel.setMaximumSize(new Dimension(SizeHelper.getPageWidth(), 75));
                this._titlePanel.setPreferredSize(new Dimension(SizeHelper.getPageWidth(), 75));
                Font titleFont = this._titleLabel.getFont().deriveFont(1, 14.0f);
                this._titleLabel.setFont(titleFont);
                this._titleLabel.setText(this._page.getDisplayText());
                this.setImage(this._page.getImageResource());
                this._imagePanel.setMinimumSize(new Dimension(SizeHelper.getPageWidth(), 100));
                this._imagePanel.setMaximumSize(new Dimension(SizeHelper.getPageWidth(), 100));
                this._imagePanel.setPreferredSize(new Dimension(SizeHelper.getPageWidth(), 100));
                this._controlPanel.add((Component)this._cancelButton, null);
                this._controlPanel.add((Component)this._backButton, null);
                this._controlPanel.add((Component)this._nextButton, null);
                this._controlPanel.add((Component)this._finishButton, null);
                this._backButton.setText(ResourceHelper.getResourceString("backButton"));
                this._cancelButton.setText(ResourceHelper.getResourceString("cancelButton"));
                this._nextButton.setText(ResourceHelper.getResourceString("nextButton"));
                this._finishButton.setText(this._ctx.getInstaller().getFinishButtonText());
                this._finishButton.setEnabled(false);
                this.setEventListeners();
                this.setIcons();
            }
            catch (Exception e) {
                this._ctx.log(e.getMessage());
                if (!this._ctx.getInstaller().isVerbose()) break block2;
                this._ctx.log(e);
            }
        }
    }

    public void setPageCompletionListener(PageCompletionListener argListener) {
        this._listener = argListener;
    }

    public abstract void updateDefaultValues();

    public abstract void updateInputFields();

    public abstract boolean validateFields() throws ValidationException;

    protected ImageIcon getImage(String resource) {
        block3: {
            try {
                if (resource != null) {
                    URL imageUrl = this.getClass().getResource(resource);
                    return new ImageIcon(imageUrl);
                }
            }
            catch (Exception ex) {
                this._ctx.log("Can't load image resource:" + resource);
                if (!this._ctx.getInstaller().isVerbose()) break block3;
                this._ctx.log(ex);
            }
        }
        return null;
    }

    private void setEventListeners() {
        this._backButton.addActionListener(e -> this._listener.pageBack(this._page));
        this._cancelButton.addActionListener(e -> {
            if (0 == JOptionPane.showConfirmDialog(null, ResourceHelper.getResourceString("cancelConfirmMessage"), ResourceHelper.getResourceString("cancelConfirmTitle"), 0)) {
                this._page.setAbort(true);
                if (this._ctx.getInstaller().isVerbose()) {
                    this._ctx.log("Abort called");
                }
                this._listener.pageComplete(this._page);
            }
        });
        this._nextButton.addActionListener(e -> this._listener.pageComplete(this._page));
        this._finishButton.addActionListener(e -> {
            if (this._finishButton.getText().equals(ResourceHelper.getResourceString("exit"))) {
                this._page.setExit(true);
                if (this._ctx.getInstaller().isVerbose()) {
                    this._ctx.log("Exit called");
                }
            }
            this._listener.pageComplete(this._page);
        });
    }

    private void setIcons() {
        this._backButton.setIcon(this.getImage("/icons/previous.png"));
        this._cancelButton.setIcon(this.getImage("/icons/cancel.png"));
        this._nextButton.setIcon(this.getImage("/icons/next.png"));
        this._finishButton.setIcon(this.getImage("/icons/finish.png"));
    }

    private void setImage(String argResource) {
        String resource = argResource;
        if (resource == null) {
            resource = this._ctx.getInstaller().getDefaultImageResource();
        }
        ImageIcon icon = this.getImage(resource);
        this._imagePanel.setIcon(icon);
    }
}

