/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.page.LicensePage;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.swing.AbstractSwingPageRenderer;
import org.tp23.antinstaller.runtime.ConfigurationException;

public class LicensePageRenderer
extends AbstractSwingPageRenderer {
    private static final long serialVersionUID = 1L;
    private final JTextArea _licenseTextArea = new JTextArea();
    private final JScrollPane _scrollPane = new JScrollPane();

    @Override
    public void instanceInit() throws IOException, ConfigurationException {
        String resource = ((LicensePage)this.getPage()).getResource();
        StringBuffer sb = new StringBuffer();
        try (InputStream licensein = this.getClass().getResourceAsStream(resource);){
            if (licensein == null) {
                throw new ConfigurationException("License resource '" + resource + "' is missing from installer");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(licensein, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
            }
        }
        this._licenseTextArea.setText(sb.toString());
        this._licenseTextArea.setTabSize(4);
        this._licenseTextArea.setAutoscrolls(true);
        this._licenseTextArea.setCaretPosition(0);
        this._licenseTextArea.setEditable(false);
        this._licenseTextArea.setLineWrap(true);
        this._licenseTextArea.setWrapStyleWord(true);
        this._licenseTextArea.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this._scrollPane.getViewport().add(this._licenseTextArea);
        this._scrollPane.setVerticalScrollBarPolicy(22);
        this._scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
        this.add((Component)this._scrollPane, "Center");
        this.getNextButton().setText(ResourceHelper.getResourceString("license.next.text"));
        this.getNextButton().setIcon(this.getImage("/icons/ok.png"));
        this.getCancelButton().setText(ResourceHelper.getResourceString("license.cancel.text"));
    }

    @Override
    public void updateDefaultValues() {
    }

    @Override
    public void updateInputFields() {
    }

    @Override
    public boolean validateFields() throws ValidationException {
        return true;
    }
}

