/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPasswordField;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.swing.ValidatedTextInputRenderer;

public class PasswordTextInputRenderer
extends ValidatedTextInputRenderer {
    public PasswordTextInputRenderer() {
        super(new JPasswordField());
    }

    @Override
    public void renderError() {
        MessageRenderer mr = this.getInstallerContext().getMessageRenderer();
        mr.printMessage(this.getErrorMessage());
        this.getTextField().requestFocus();
        this.getTextField().setForeground(Color.red);
        this.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() != '\t') {
                    PasswordTextInputRenderer.this.setInputFieldEdited(true);
                }
            }
        });
    }

    protected String getErrorMessage() {
        return ResourceHelper.getResourceString("notCorrectPasswordFormat") + "\n\n e.g. " + this.getInputField().getDefaultValue();
    }
}

