/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.BuildEvent;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.renderer.swing.ProgressPanel;
import org.tp23.antinstaller.runtime.SwingRunner;

public class SwingInstallerContext {
    private final JFrame _masterFrame;
    private final InstallerContext _ctx;
    private JLabel _feedBackPanel;
    private ProgressPanel _progressPanel;

    public SwingInstallerContext(InstallerContext argCtx, JFrame argMasterFrame) {
        this._ctx = argCtx;
        this._masterFrame = argMasterFrame;
    }

    public void buildFinished(BuildEvent buildEvent) {
        if (this._progressPanel != null) {
            try {
                SwingUtilities.invokeLater(() -> this._progressPanel.buildFinished());
            }
            catch (Exception e) {
                this._ctx.log(e);
            }
        }
    }

    public void buildStarted(BuildEvent buildEvent) {
        this.provideAntFeedBack(buildEvent.getMessage());
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (this._progressPanel != null) {
                    this._progressPanel.prepareCalledTargets();
                }
            });
        }
        catch (Exception e) {
            this._ctx.log(e);
        }
    }

    public InstallerContext getInstallerContext() {
        return this._ctx;
    }

    public JFrame getMasterFrame() {
        return this._masterFrame;
    }

    public SwingRunner getSwingRunner() {
        return (SwingRunner)this._ctx.getRunner();
    }

    public void provideAntFeedBack(String message) {
        try {
            if (this._feedBackPanel != null) {
                SwingUtilities.invokeLater(() -> this._feedBackPanel.setText(message));
            }
        }
        catch (Exception e) {
            this._ctx.log(e);
        }
    }

    public void setFeedBackLabel(JLabel argFeedBackPanel) {
        this._feedBackPanel = argFeedBackPanel;
    }

    public void setProgressPanel(ProgressPanel argProgressPanel) {
        this._progressPanel = argProgressPanel;
    }

    public void targetFinished(BuildEvent buildEvent) {
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (this._progressPanel != null) {
                    this._progressPanel.targetFinished();
                }
            });
        }
        catch (Exception e) {
            this._ctx.log(e);
        }
    }

    public void targetStarted(BuildEvent buildEvent) {
        try {
            if (this._progressPanel != null) {
                SwingUtilities.invokeAndWait(() -> this._progressPanel.targetStarted(buildEvent));
            }
        }
        catch (Exception e) {
            this._ctx.log(e);
        }
    }
}

