/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.Console;
import java.io.IOException;
import java.util.List;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.LargeSelectInput;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.text.Pager;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class LargeSelectInputRenderer
implements TextOutputFieldRenderer {
    private InstallerContext _ctx;

    @Override
    public boolean isAbort() {
        return false;
    }

    @Override
    public void renderError(AbstractInputField field, Console console) throws IOException {
        this._ctx.getMessageRenderer().printMessage("Not a valid selection");
        this.renderOutput(field, console);
    }

    @Override
    public void renderOutput(AbstractInputField field, Console console) throws IOException {
        LargeSelectInput iField = (LargeSelectInput)field;
        this.printText(iField, console);
        String input = console.readLine();
        console.format("%n", new Object[0]);
        if (input == null || "".equals(input)) {
            input = iField.getDefaultValue();
        } else {
            try {
                int idx = Integer.parseInt(input.trim());
                input = iField.getOptions().get(idx - 1).getValue();
            }
            catch (Exception numFormatOrIndexOutOfBounds) {
                return;
            }
        }
        iField.setInputResult(input);
    }

    @Override
    public void setContext(InstallerContext argCtx) {
        this._ctx = argCtx;
    }

    private String getNextInstructions() {
        return ResourceHelper.getResourceString("large_select_next");
    }

    private void printText(LargeSelectInput iField, Console console) {
        console.format(iField.getDisplayText() + "%n", new Object[0]);
        List<LargeSelectInput.Option> options = iField.getOptions();
        console.format("  ", new Object[0]);
        console.format(ResourceHelper.getResourceString("availableOptions") + "%n", new Object[0]);
        StringBuffer optionsData = new StringBuffer();
        for (int i = 0; i < options.size(); ++i) {
            optionsData.append("  ");
            optionsData.append(i + 1);
            optionsData.append(") ");
            optionsData.append(options.get(i).getText());
            if (iField.getDefaultValue().equals(options.get(i).getValue())) {
                optionsData.append(" [");
                optionsData.append(ResourceHelper.getResourceString("_default_"));
                optionsData.append("]");
            }
            optionsData.append("\n");
        }
        optionsData.append("  ");
        optionsData.append(ResourceHelper.getResourceString("enterNumber")).append("\n");
        Pager pager = new Pager(optionsData.toString());
        String command = null;
        while (pager.next(console)) {
            console.format("%n", new Object[0]);
            command = console.readLine("%s: ", this.getNextInstructions());
            if (command.toUpperCase().startsWith(ResourceHelper.getResourceString("nextChar"))) continue;
        }
        pager.rest(console);
    }
}

