/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.Console;
import java.io.IOException;
import java.util.Arrays;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AbstractInputField;
import org.tp23.antinstaller.input.PasswordTextInput;
import org.tp23.antinstaller.renderer.ResourceHelper;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;
import org.tp23.antinstaller.renderer.text.ValidatedTextInputRenderer;

public class PasswordTextInputRenderer
extends ValidatedTextInputRenderer
implements TextOutputFieldRenderer {
    @Override
    public boolean isAbort() {
        return false;
    }

    @Override
    public void renderError(AbstractInputField field, Console console) throws IOException {
        console.format(this.getErrorMessage() + "%n", new Object[0]);
        this.renderOutput(field, console);
    }

    @Override
    public void renderOutput(AbstractInputField field, Console console) throws IOException {
        PasswordTextInput iField = (PasswordTextInput)field;
        String initialValue = iField.getDefaultValue();
        if (iField.getInitialValue() != null) {
            initialValue = iField.getInitialValue();
        }
        char[] passwordChars = console.readPassword("%s   [%s:%s]: ", field.getDisplayText(), ResourceHelper.getResourceString("_default_"), initialValue);
        String input = new String(passwordChars);
        Arrays.fill(passwordChars, ' ');
        console.format("%n%n", new Object[0]);
        if (input == null || "".equals(input)) {
            input = initialValue;
        }
        iField.setInputResult(input);
    }

    @Override
    public void setContext(InstallerContext argCtx) {
    }

    protected String getErrorMessage() {
        return ResourceHelper.getResourceString("notCorrectPasswordFormat");
    }
}

